<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class QuestionReplies extends Model
{
    protected $table = 'questions_replies';

    protected $fillable = [
        'video_id', 'question_id', 'status', 'coach_id'
    ];

    public function coach()
    {
        return $this->belongsTo('App\User','coach_id');
    }

    public function question()
    {
        return $this->belongsTo('App\Question', 'question_id');
    }

    public function Video()
    {
        return $this->belongsTo('App\Video', 'video_id');
    }

    public function getCreatedAtAttribute($value)
    {
        $timezone = optional(auth()->user())->timezone ?? config('app.timezone');
        return Carbon::parse($value)->timezone($timezone);
    }

    public function getUpdatedAtAttribute($value)
    {
        $timezone = optional(auth()->user())->timezone ?? config('app.timezone');
        return Carbon::parse($value)->timezone($timezone);
    }
}


