<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\User;

class Verification extends Mailable
{
    use Queueable, SerializesModels;

    public $first_name;
    public $last_name;
    public $message;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(User $user)
    {
        //
        $this->first_name = $user->first_name;
        $this->last_name = $user->last_name;
        //$this->message = $message;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        /*return $this->subject('Iviggo | Email Confirmation')->markdown('emails.usersignup')->with([
            'first_name' => $this->firstname,
            'last_name' => $this->lastname,
            'message'  => $this->message
        ]);*/

        return $this->subject('Iviggo | Medlemstilmelding')->view('emails.usersignup');
    }
}
