<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\UserPackage;


class PaymentProcessed extends Mailable
{
    use Queueable, SerializesModels;

    public $info;
    public $vat;
    public $renew;
    public $user;
    public $qpayment;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(UserPackage $package,$qPayment, $vatInfo, $userData, $renew='no')
    {
        //

        $this->info = $package;
        $this->vat = $vatInfo;
        $this->renew = $renew;
        $this->user = $userData;
        $this->qpayment = $qPayment;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        /*return $this->subject('Iviggo - Payment Processed')->markdown('emails.payment_processed')->with([
            'info' => $this->info
        ]);*/

        return $this->subject('Betaling behandlet')->view('emails.payment_processed');
    }
}
