<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\User;
use App\CoachIntro;


class IntroVideoActive extends Mailable
{
    use Queueable, SerializesModels;

    public $first_name;
    public $last_name;
    public $video_title;
    public $type;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(CoachIntro $video)
    {
        //

        $this->first_name = $video->user->first_name;
        $this->last_name = $video->user->last_name;
        $this->video_title = $video->video_title;
        $this->type = 'intro';
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject((($this->type=='intro') ? 'Introductory ':'').'Video Approved')->view('emails.video_approved');
    }
}
