<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\User;

class IntroVideo extends Mailable
{
    use Queueable, SerializesModels;

    public $firstname;
    public $lastname;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(User $user)
    {
        //
        $this->firstname = $user->first_name;
        $this->lastname = $user->last_name;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject('Coach Introduction Video')->view('emails.IntroVideo');
    }
}
