<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\User;

class InactiveAccountPassword extends Mailable
{
    use Queueable, SerializesModels;

    public $username;
    public $link;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(User $user)
    {
        $this->username = $user->first_name.' '.$user->last_name;
        $this->link = route('password.create', ['token' => $user->new_password_token]);
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject('Create Password')->view('emails.inactive_account');
    }
}
