<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\User;
use App\Createcompany;


class CompanyRegistration extends Mailable
{
    use Queueable, SerializesModels;

    public $first_name;
    public $last_name;
    public $video_title;
    public $type;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(Createcompany $company)
    {
        $this->first_name = $company->owner_first_name;
        $this->last_name = $company->owner_last_name;
        $this->company_registered_members = $company->company_registered_members;
        $this->company_pending_members = $company->company_pending_members;
        $this->company_total_members = $company->company_total_members;
        $this->employee_email = $company->employee_email;
        $this->company_name = $company->company_name;
        $this->type = 'Medarbejderregistrering '. $company->company_name;

    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject('Medarbejderregistrering')->markdown('emails.companyregistration')->with([
            'first_name' => $this->first_name,
            'last_name' => $this->last_name,
            'type' => $this->type,
            'company_registered_members' => $this->company_registered_members,
            'company_pending_members' => $this->company_pending_members,
            'company_total_members' => $this->company_total_members,
            'employee_email' => $this->employee_email,
            'company_name' => $this->company_name
        ]);
    }
}
