<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\User;

class CoachSignup extends Mailable
{
    use Queueable, SerializesModels;

    public $first_name;
    public $last_name;
    public $toAdmin;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(User $user,$toAdmin = 'no')
    {
        //
        $this->first_name = $user->first_name;
        $this->last_name = $user->last_name;
        $this->toAdmin = $toAdmin;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        /*return $this->subject('Coach Signup')->markdown('emails.coachsignup')->with([
            'first_name' => $this->firstname,
            'last_name' => $this->lastname,
        ]);*/
        return $this->subject('Træner tilmelding')->view('emails.coachsignup');
    }
}
