<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
use App\User;
use Spatie\Permission\Traits\HasRoles;
use Carbon\Carbon;


class CheckSubscription
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */

    use HasRoles;


    public function handle($request, Closure $next)
    {
        $user = Auth::user();

        if(isset($user->id)) {
            $checkSub = new User();
            $status = $checkSub->checkSubscription($user);
            if($status['status']=='error') {
                return redirect()->route($status['route']);
            }
        }

        // dates handles goes here
        return $next($request);
    }
}
