<?php

namespace App\Http\Middleware;

use App\Providers\RouteServiceProvider;
use Illuminate\Auth\Middleware\Authenticate as Middleware;
use Illuminate\Support\Facades\Auth;
use App\User;

class Authenticate extends Middleware
{
    /**
     * Get the path the user should be redirected to when they are not authenticated.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return string|null
     */
    protected function redirectTo($request)
    {
        if (! $request->expectsJson()) {
            if ($request->getHttpHost() === config('app.marketing_domain')) {

                return route('home.marketing');
            } else {
                return route('login');
            }
            return route('login');
        }

        if (Auth::guest()) {

                return redirect()->route('/');

        }

        $user = User::find(Auth::user()->id);


        if (!isset($user->id)) {
            Auth::logout();
            return Redirect::route('login')->with('global', 'Your account has been deleted!');
        }
    }
}
