<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Support\Facades\Auth;
use Spatie\Permission\Traits\HasRoles;

class AdminMiddleware
{
    use AuthenticatesUsers;
    use HasRoles;
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {


        if (Auth::guest()) {
            return redirect()->route('home.front');
        }

        if (! Auth::user()->hasRole('superadmin')) {
            return redirect()->route('home.front');
        }

        return $next($request);
    }
}
