<?php

namespace App\Http\Controllers;

use App\CoachProfileInfo;
use App\Http\Controllers\TrialController;
use App\Package;
use App\QuickpaySubscriptions;
use App\UserPackagePrices;
use Illuminate\Http\Request;
use App\User;
use Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use Illuminate\Auth\Events\Registered;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Traits\HasRoles;
use Illuminate\Support\Facades\Mail;
use App\Mail\CoachSignup;
use Illuminate\Support\Facades\File;
use App\Countries;
use Illuminate\Support\Str;
use App\Traits\UploadTrait;
use App\Mail\Verification;
use App\Mail\TrialVerification;
use QuickPay\QuickPay;
use App\UserPackage;
use Carbon\Carbon;
use Illuminate\Support\Facades\Crypt;
use App\Http\Controllers\PaymentController;

class UserSignupController extends Controller
{

    private $guest;
    protected $user_id;
    protected $redirectTo = '/thanks';
    use HasRoles;
    use UploadTrait;

    public function __construct()
    {
        $this->middleware(['guest']);
    }

    protected function validator(array $data)
    {
        $validator = Validator::make($data, [
            'user' => 'required|array',
            'user.first_name' => 'required|min:2|max:40',
            'user.last_name' => 'required|min:2|max:80',
            'user.email' => 'required|email|unique:users,email',
            'user.password' => 'required|min:8|max:30|confirmed|secure_password',
            'general' => 'sometimes|array',
            /*'general.referral_invite_code' => 'ref_invite_code',
            'general.invite_code' => 'unique:coach_profile,invite_code',*/
            //'general.referral_invite_code' => 'ref_invite_code|regex:/^[a-zA-Z0-9]+$/|nullable',
            //'general.invite_code' => 'required|unique:coach_profile,invite_code|regex:/^[a-zA-Z0-9]+$/',
            'general.country' => 'required|alpha_spaces',
            'package' => 'required|integer',
            'g-recaptcha-response' => 'required|recaptcha',
        ], [

           // 'general.referral_invite_code.ref_invite_code' => 'The Referral Invitation Code not found. Please enter correct referral invite code.',
            //'general.referral_invite_code.regex' => 'The Referral Invitation Code field must have valid characters and without spaces.',
            //'general.invite_code.unique' => 'The Invitation Code is already in use. Please enter unique invite code.',
        ],
            ['user.first_name' => 'First Name',
            'user.last_name' => 'Last name',
            'user.email' => 'Email',
            'user.password' => 'Password',
            'g-recaptcha-response' => 'Captcha',
            'g-recaptcha-response.recaptcha' => 'Captcha verification failed',
            'g-recaptcha-response.required' => 'Please complete the captcha',
            'general.referral_invite_code' => 'Referral Invite Code',
            'general.invite_code' => 'Invite Code',
            'general.country' => 'Country']);


        return $validator;
    }

    public function create(Request $request)
    {
        $id =  $request->route('id');


        if($request->coachurl) {
            $coachurl = $request->coachurl;
        }


        if(!is_numeric($id) || $id == 0)
        {
            return redirect('/join');
        }

        $packages = Package::pluck('id')->toArray();

        if( !in_array($id, $packages) )
        {
            return redirect('/join');
        }



        $data['countries'] = Countries::pluck('country_name','country_code')->toArray();;
        $data['package'] = $id;
        $data['packageInfo'] = Package::find($id);
        $data['coachurl'] = $coachurl;
        //return $data['packageInfo'];

        return view('pages.user_signup', $data);
    }



    public function join(Request $request)
    {
        if($request->coachurl) {
            $coachurl = $request->coachurl;
        }
        if(isset($coachurl)) {
            $coachId = CoachProfileInfo::where('coach_url', $coachurl)->get(['created_user_id'])->first()->created_user_id;
        }else{
            $coachId = '';
        }
        $data['packages'] = Package::where(['visible'=>'yes'])->where('created_user_id', $coachId)->get();
        $isTrial = config('iviggo.trial');
        $data['isTrial'] = $isTrial;
        if($isTrial==true) {
            $data['trial'] = Package::find(config('iviggo.trial_package_id'));
        }

        //return $data;

        return view('pages.join', $data);
    }




    public function submit(Request $request)
    {

        $this->validator($request->all())->validate();
        $this->submit = $request->input('submit');

        $user = $request->user;
        $general = $request->general;
        $package = $request->package;
        $coachId  = CoachProfileInfo::where('coach_url',$general['coachurl'])->get(['created_user_id'])->first()->created_user_id;
        //return $general['country'];
        $guest = User::create([
            'first_name' => $user['first_name'],
            'last_name' => $user['last_name'],
            'email' => $user['email'],
            'password' => bcrypt($user['password']),
            'new_password_token' => Str::random(40),
            'status' => 'active',
            'verification_code'=>substr(md5(rand()),0,7),
            'coach_id' => $coachId
        ]);

        $guest->assignRole('user');

        if (isset($guest->id)) {
            $this->default_condition = ["created_user_id" => $guest->id, "updated_user_id" => $guest->id];

            $general['mobile'] = $general['phone'];
            $adminCode = User::role('superadmin')->pluck('id');
            $adminUser =  User::with(['coachInfo'])->find($adminCode)->first();
            $general['referral_invite_code'] = $adminUser['coachInfo']['invite_code'];
            CoachProfileInfo::updateOrCreate($this->default_condition, $general);
            Mail::to($guest->email)->send(new Verification($guest));


            $packageInfo = Package::find($package);
            $packageInfo['price_for_customer'] = $general['price_for_customer'];
            Countries::where('country_code',$general['country'])->orderBy('id','desc')->first();

            /* $userPackage = UserPackage::create([
                 'package_id' => $packageInfo->id,
                 'starts_at' => Carbon::now()->toDateTimeString(),
                 'state' => 'pending',
                 'ends_at' => Carbon::now()->add($packageInfo->invoice_period,$packageInfo->invoice_interval)->toDateTimeString(),
                 'created_user_id' => $guest->id,
                 'updated_user_id' => $guest->id,
             ]);*/


            if ($request->session()->exists('signup_token')) {
                $request->session()->forget('signup_token');
            } else {
                session(['signup_token' => $guest->new_password_token]);
            }

            UserPackagePrices::create([
                'user_id' => $guest->id,
                'package_id' => $packageInfo->id,
                'price_for_customer' =>$packageInfo->price_for_customer
            ]);

            $paymentController = new PaymentController();
            return $paymentController->createSubscription(['user'=>$guest,'packageInfo'=>$packageInfo]);

            /*


            //$guest->newSubscription('main', $plan);

            $isTrial = config('iviggo.trial');
            $data['isTrial'] = $isTrial;
            if($isTrial==true) {



                $paymentController = new TrialController();
                $packageInfo = Package::find(config('iviggo.trial_package_id'));

                $expiry_date = Carbon::now()->add($packageInfo->invoice_period, $packageInfo->invoice_interval)->toDateTimeString();
                Mail::to($guest->email)->send(new TrialVerification($guest,$expiry_date));


            } else {
                Mail::to($guest->email)->send(new Verification($guest));
                $paymentController = new PaymentController();
                $packageInfo = Package::find($package);
            }


            Countries::where('country_code',$general['country'])->orderBy('id','desc')->first();

            $userPackage = UserPackage::create([
                'package_id' => $packageInfo->id,
                'starts_at' => Carbon::now()->toDateTimeString(),
                'state' => 'pending',
                'ends_at' => Carbon::now()->add($packageInfo->invoice_period,$packageInfo->invoice_interval)->toDateTimeString(),
                'created_user_id' => $guest->id,
                'updated_user_id' => $guest->id,
            ]);


            if ($request->session()->exists('signup_token')) {
                $request->session()->forget('signup_token');
            } else {
                session(['signup_token' => $guest->new_password_token]);
            }













                return $paymentController->createSubscription(['user'=>$guest,'packageInfo'=>$packageInfo,'renew_package'=>$package]);*/


        }



        //$message= route('verify.email', ['email' => base64_encode($guest->email),'secret'=>base64_encode($guest->verification_code)]);






        return redirect()->route('signup.thanks', 2);

    }


}
