<?php

namespace App\Http\Controllers;

use App\CoachProfileInfo;
use App\Commissions;
use App\Countries;
use Illuminate\Support\Str;

use App\Traits\UploadTrait;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use App\Package;
use App\UserPackage;
use App\User;
use Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use App\Mail\PaymentProcessed;
use App\Mail\PaymentError;
use App\QuickpaySubscriptions;
use App\QuickpayPayments;
use App\QuickpayRecurring;
use QuickPay\QuickPay;
use Illuminate\Support\Facades\Crypt;
use Spatie\Permission\Traits\HasRoles;
use App\Http\Controllers\PaymentController;


class TrialController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */

    protected $user;
    use UploadTrait;
    use HasRoles;

    public function __construct()
    {
        // $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */


    public function createSubscription($data)
    {

        Log::info('===================================================================================================');

        Log::info('creating trial');


            $orderID = time();

            //Create payment

            $userDetails = User::with('coachInfo')->find($data['user']->id);






            $userPackage = UserPackage::create([
                'package_id' => $data['packageInfo']->id,
                'state' => 'Approved',
                'status' => 'active',
                'recurring' => 'inactive',
                'renew_package' => $data['renew_package'],
                'created_user_id' => $data['user']->id,
                'updated_user_id' => $data['user']->id,
            ]);
            $userPackage->subscription_id = $orderID;
            $userPackage->starts_at = Carbon::now()->toDateTimeString();
            $userPackage->ends_at = Carbon::now()->add($data['packageInfo']->invoice_period, $data['packageInfo']->invoice_interval)->toDateTimeString();
            $userPackage->save();

            QuickpaySubscriptions::updateOrCreate(
                ['created_user_id' => $data['user']->id, 'subscription_id' => $orderID, 'order_id' => "ivsub" .$data['user']->id . $orderID],
                ['state'=>'active','accepted'=>'Yes','user_package'=>$userPackage->id]
            );


            $paymentController = new PaymentController();
            $commisionInfo = $paymentController->commission($userDetails,$userPackage);

            $encryptedStr = Crypt::encryptString($data['user']->id . '**' . $data['user']->id . $orderID . '**recurring');
            return redirect()->route('payment.trial_success', ['token' => $encryptedStr]);



    }



}
