<?php

namespace App\Http\Controllers;

use App\CoachCompanyEmployee;
use App\CoachProfileInfo;
use App\Commissions;
use App\Countries;
use App\Createcompany;
use App\UserCompanies;
use App\UserPackage;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Log;
use Spatie\Permission\Traits\HasRoles;
use App\Package;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use App\User;
use Illuminate\Support\Facades\DB;
use Auth;



class RetrievecompaniesController extends Controller
{
    use HasRoles;

    protected function editvalidator(array $data,$id)
    {
        return Validator::make($data, [
            'title' => 'required|max:255',
            'description' => 'required',
            'button_text' =>'required',
            'invoice_period' => 'required',
            'renew_button_text' => 'required',
        ]);
    }


    public function index()
    {
        $this->user = Auth::user();
        $adminIds = User::role('superadmin')->pluck('id')->toArray();
        if(in_array($this->user->id,$adminIds)) {
            $companies = Createcompany::orderby('company_id', 'DESC')->get();
            return view('pages.coach_retrievecompanies',['companies'=>$companies]);
        }else {
            if (isset($this->user->id)) {
                $companies = Createcompany::orderby('company_id', 'DESC')->where('coach_id', $this->user->id)->get();
                return view('pages.coach_retrievecompanies', ['companies' => $companies]);
            } else {
                return redirect()->route('home.front');
            }
        }

    }


    public function delete($id) {
        $this->user = Auth::user();

        $companies = Createcompany::orderby('company_id', 'DESC')->where('coach_id',$this->user->id)->get();
        if(count($companies) <= 0 ){
            return redirect()->route('home.front');
        }
        if (!is_numeric($id) || $id == 0 || strpos($id, ".")) {
            return view('pages.coach_retrievecompanies',['companies'=>$companies]);
        }

        $record = CoachCompanyEmployee::find($id);
        $recordUserDelete = User::find($record->employee_id);

        if(isset($recordUserDelete->id)) {
            if ($recordUserDelete->delete()) {
                if(isset($record->id)) {
                    $record->delete();
                    Auth::setUser($recordUserDelete);
                    Auth::logout();
                    Auth::setUser($this->user);
                    Auth::login($this->user);
                    return back()->with('message','Employee account is deleted');
                }
            }
        }/*else{
            return redirect()->route('home.front');
        }*/
        return view('pages.coach_retrievecompanies',['companies'=>$companies]);
    }



    public function viewpaymenthistory($id)
    {
        $this->user = Auth::user();
        if(isset($this->user->id)) {
            $companyId = UserCompanies::select('id')->where(['company_id' => $id])->get()->pluck('id')->toArray();
            $q = function ($q) use ($companyId) {
                $q->orderBy('id', 'desc')->with(['companyQuickpayPayments' => function ($query) use ($companyId) {
                    $query->orderBy('id', 'desc');
                    $query->whereIn('company_id', $companyId);
                }]);

            };
            $data['record'] = UserCompanies::with(['user', 'quickpaySubscription' => $q])->where('company_id', $id)->where('status', 'active')->orderBy('id', 'desc')->first();

            if ($data['record']) {
                $data['companyDetails'] = Createcompany::where(['company_id' => $data['record']->company_id])->first();
                return view('pages.coach_retrievecompanieshistory', $data);
            } else {
                return back()->with('errmessage', 'Ingen registrering fundet.');
            }
        }else{
            return redirect()->route('home.front');
        }
    }

    public function viewCompanyEmployees($id)
    {
        $this->user = Auth::user();
        if(isset($this->user->id)) {
            $companyEmployees = DB::table('company_employee_coach')
                ->select('company_employee_coach.id', 'employee_id')
                ->join('users', 'company_employee_coach.coach_id', '=', 'users.id')
                ->where(['company_id' => $id, 'users.id' => $this->user->id])
                ->get();
        }else{
            return redirect()->route('home.front');
        }

        if(count($companyEmployees) == 0){
            return redirect('/coach/retreiveCompanies')->with('errmessage', 'Beklager, ingen medarbejdere fundet');
        }

        if(count($companyEmployees) > 0) {
            foreach ($companyEmployees as $employee) {
                $company = User::select('id', 'first_name', 'last_name', 'email', 'created_at')->orderby('id', 'DESC')->where('id', $employee->employee_id)->get();
                foreach ($company as $emp) {
                    $data[$emp->id]['first_name'] = $emp['first_name'];
                    $data[$emp->id]['id'] = $employee->id;
                    $data[$emp->id]['last_name'] = $emp['last_name'];
                    $data[$emp->id]['email'] = $emp['email'];
                    $data[$emp->id]['created_at'] = $emp['created_at'];
                }

            }
        }else{
            $data= [];
        }
        if(isset($data)) {
            return view('coaches.company.company_employees', array('users' => $data));
        }else{
            return back()->with('errmessage' , 'Sorry, no employees found for this company.');
        }
    }

    public function edit($id)
    {

        $page = Createcompany::where('company_id', '=', $id)->get()->first();
        $countries = Countries::pluck('country_name','country_code')->toArray();;
        return view('pages.coach_editcompany',['company'=>$page, 'countries'=>$countries]);
    }

    public function submit(Request $request)
    {

        $this->user = Auth::user();

        $page = Createcompany::where('company_id', $request->input('id'))->get(['id'])->first();

        if($page) {
            $this->editvalidator($request->all(),$request->input('id'))->validate();

            $page->title = $request->input('title');
            $page->description = $request->input('description');
            $page->button_text = $request->input('button_text');
            $page->invoice_period = $request->input('invoice_period');
            $page->invoice_interval = 'month';
            $page->renew_button_text = $request->input('renew_button_text');
            $page->created_user_id = $this->user->id;
            $page->updated_user_id = $this->user->id;

            $page->save();
        }

        return redirect(route('bo.packages'));
    }

}
