<?php

namespace App\Http\Controllers;

use App\CoachProfileInfo;
use App\Commissions;
use App\CompanyQuickpayPayments;
use App\CompanyQuickpaySubscriptions;
use App\Countries;
use App\Createcompany;
use App\GiftCard;
use App\Mail\CompanyEmployeesEmail;
use App\Mail\CompanyPaymentProcessed;
use App\UserCompanies;
use App\UserPackagePrices;
use Illuminate\Support\Str;

use App\Traits\UploadTrait;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use App\Package;
use App\UserPackage;
use App\User;
use Auth;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use App\Mail\PaymentProcessed;
use App\Mail\PaymentError;
use App\QuickpaySubscriptions;
use App\QuickpayPayments;
use App\QuickpayRecurring;
use QuickPay\QuickPay;
use Illuminate\Support\Facades\Crypt;
use Spatie\Permission\Traits\HasRoles;
use App\SpeakersPool;


class PaymentController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */

    protected $user;
    use UploadTrait;
    use HasRoles;

    public function __construct()
    {
        // $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function fail(Request $request)
    {


        if ($request->has('token')) {
            $decrypted = Crypt::decryptString($request->query('token'));
            $query = explode('**', $decrypted);
            //return $query;
            $data['link'] = '';

            if ($request->session()->has('qp_link')) {
                $data['link'] = $request->session()->pull('qp_link');
            }

            return view('pages.payment_fail',$data);


            /*if (is_array($query) && count($query) == 3) {

                $data['record'] = UserPackage::with(['user', 'plan'])->where(['created_user_id' => $query['0']])->first();


            } else {
                abort(404);

            }*/


        }

        return redirect('/');
    }

    public function upgrade($id = false)
    {
        $this->user = Auth::user();
        $userData = User::with(['coachInfo'])->find($this->user->id);
        // $parents = CoachProfileInfo::where('invite_code',$userData->coachInfo->invite_code)->with(['User'])->first();
        $userPackage = UserPackage::with(['user', 'plan', 'quickpaySubscription'])->where(['created_user_id' => $this->user->id, 'status' => 'active'])->first();

        $data['vatInfo'] = Countries::where('country_code',$userData->coachInfo->country)->orderBy('id','desc')->first();

        if ($id) {

            if (!is_numeric($id)) {
                return redirect()->route('user.renew_package');
            }

            $subData = UserPackage::with(['user', 'plan', 'quickpaySubscription'])->where(['created_user_id' => $this->user->id, 'status' => 'active'])->first();

            $action = 'renew';
            $packageInfo = Package::find($id);
            if (isset($subData->id)) {

                Log::info('Update Package');
//                $opening = UserPackage::find($subData->id);
                if ($subData->state == 'Approved') {

                    Log::info('Old Package approved');
                    session(['upgrade_package' => true, 'old_package'=>$subData->id,'new_plan_id'=>$id]);
                    $data['old_package'] = $subData->id;
                    $data['upgrade_package'] = true;
                    $data['new_plan_id'] = $id;
                }

                if($subData->recurring == 'active' && $subData->package_id==$id) {

                    $userPackage = UserPackage::updateOrCreate(
                        ['created_user_id'=>$subData->created_user_id, 'subscription_id'=>$subData->subscription_id, 'package_id'=>$id, 'status' => 'inactive']
                        ,[
                        'subscription_id' => $subData->subscription_id,
                        'package_id' => $packageInfo->id,
                        'starts_at' => Carbon::now()->toDateTimeString(),
                        'state' => 'Awaiting Payment Confirmation',
                        'status' => 'inactive',
                        'ends_at' => Carbon::now()->add($packageInfo->invoice_period, $packageInfo->invoice_interval)->toDateTimeString(),
                        'created_user_id' => $subData->created_user_id,
                        'updated_user_id' => $subData->created_user_id,
                    ]);
                    //$userPackage->subscription_id = $payload['subscription_id'];
                    $userPackage->save();
                    $userPackage = UserPackage::with(['plan', 'user'])->find($userPackage->id);

                    // For new subscriptions (Discounted (using invitation code))
                    $userDetail = UserPackagePrices::where('user_id', $this->user->id)->first();
                    Log::info('ID: '.$this->user->id);
                    Log::info('User Detail : user Package'.json_encode($userDetail));
                    if(isset($userDetail->id)) {
                        $priceForCustomer = $userDetail->price_for_customer;
                        $userInformation = User::with('coachInfo')->find($this->user->id);
                        $vatDetails = Countries::where('country_code', 'DK')->orderBy('id', 'desc')->first();
                        $percentTotal = ($priceForCustomer * $vatDetails->vat_rate) / 100;
                        $totals = ($priceForCustomer + $percentTotal) * 100;
                    } else {
                        $totals = '';
                        $priceForCustomer = '';
                    }
                    Log::info('Totals: '.$totals);
                    Log::info('Price for customer: '.$priceForCustomer);
                    // For new subscriptions (Discounted (using invitation code))

                    return $this->createrecurring($subData, $data,$totals,$priceForCustomer);
                }

                $data['user'] = $subData->user;
                $data['userPackage'] = $subData;
                $data['packageInfo'] = $packageInfo;

                return $this->createSubscription($data);
                //}


            } else {


                $data['user'] = $this->user;
                $data['userPackage'] = $subData;
                $data['packageInfo'] = $packageInfo;

                return $this->createSubscription($data);
            }



        }

        $data['packages'] = Package::where(['visible'=>'yes'])->where('created_user_id', $this->user->coach_id)->get();
        //return $data;


        return view('pages.upgrade', $data);

    }

    public function success(Request $request)
    {

        if ($request->has('token')) {
            $decrypted = Crypt::decryptString($request->query('token'));
            $query = explode('**', $decrypted);
            return view('pages.payment_success');
            //return count($query);

            /*if (is_array($query) && count($query) == 3) {
               // $data['record'] = UserPackage::with(['user', 'plan'])->where(['created_user_id' => $query['0']])->first();
                //return $data;
                return view('pages.payment_success');
            } else {
                abort(404);

            }*/


        }

        return redirect('/');

    }

    public function giftsuccess(Request $request)
    {

        if ($request->has('token')) {
            $decrypted = Crypt::decryptString($request->query('token'));
            $query = explode('**', $decrypted);
            return redirect()->route('users.gift.receiver', ['rId' => $request->query('uId'),'sId' => $request->query('user_id'), 'pId' => $request->query('packageId') ]);
        }

        return redirect('/');

    }



    public function companySuccess(Request $request)
    {
        return view('pages.company_payment_success');

    }

    public function trialsuccess(Request $request)
    {

        if ($request->has('token')) {
            $decrypted = Crypt::decryptString($request->query('token'));
            $query = explode('**', $decrypted);
            return view('pages.trial_payment_success');
            //return count($query);

            /*if (is_array($query) && count($query) == 3) {
               // $data['record'] = UserPackage::with(['user', 'plan'])->where(['created_user_id' => $query['0']])->first();
                //return $data;
                return view('pages.payment_success');
            } else {
                abort(404);

            }*/


        }

        return redirect('/');

    }


    public function info(Request $request)
    {


        Log::info('CallBack------------');
        $incoming = $request->getContent();

        Log::info('Incoming - From Callback: '.$incoming);

        $incoming = json_decode($incoming, true);
        //sleep(5);

        if (isset($incoming['id']) && Str::startsWith($incoming['order_id'], 'ivsub')) {
            Log::info('Subscription Update');
            $payload = [];
            $payload['subscription_id'] = $incoming['id'];
            $payload['order_id'] = $incoming['order_id'];
            $payload['created_at'] = Carbon::parse($incoming['created_at'])->toDateTimeString();
            $payload['updated_at'] = Carbon::parse($incoming['updated_at'])->toDateTimeString();
            $payload['metadata'] = json_encode($incoming['metadata']);
            $payload['link'] = $incoming['link']['url'];
            $payload['agreement_id'] = $incoming['link']['agreement_id'];
            $payload['amount'] = $incoming['link']['amount'];
            $payload['payment_methods'] = $incoming['link']['payment_methods'];
            $payload['accepted'] = ($incoming['accepted'] == true) ? 'Yes' : 'No';
            //$payload['created_user_id'] = $incoming['variables']['user_id'];
            $payload['operations'] = json_encode($incoming['operations']);
            $payload['package'] = $incoming['variables']['package'];
            //payload['vat'] = $incoming['variables']['vat_rate'];
            $payload['state'] = $incoming['state'];
            $userID = $incoming['variables']['user_id'];
            if(isset($incoming['variables']['price_for_customer'])) {
                $priceForCustomer = $incoming['variables']['price_for_customer'];
            }

            if(isset($incoming['variables']['old_package']) && isset($incoming['variables']['upgrade_package']) && isset($incoming['variables']['new_plan_id'])) {
                $Oldpayload['old_package'] = $incoming['variables']['old_package'];
                $Oldpayload['upgrade_package'] = $incoming['variables']['upgrade_package'];
                $Oldpayload['new_plan_id'] = $incoming['variables']['new_plan_id'];
            }

            $amount = $incoming['link']['amount'];


            $operationsPay = end($incoming['operations']);

            Log::info('Operations...');
            Log::info(json_encode($payload));
            $packageInfo = Package::find($payload['package']);

            if (isset($packageInfo->id)) {
                Log::info('new package');
                $userPackage = UserPackage::updateOrCreate(
                    ['created_user_id'=>$userID, 'subscription_id'=>$payload['subscription_id'], 'package_id'=>$packageInfo->id]
                    ,[
                    'subscription_id'=>$payload['subscription_id'],
                    'package_id' => $packageInfo->id,
                    'starts_at' => Carbon::now()->toDateTimeString(),
                    'state' => 'Awaiting Payment Confirmation',
                    'status' => 'inactive',
                    'ends_at' => Carbon::now()->add($packageInfo->invoice_period, $packageInfo->invoice_interval)->toDateTimeString(),
                    'created_user_id' => $userID,
                    'updated_user_id' => $userID,
                ]);
                //$userPackage->subscription_id = $payload['subscription_id'];
                $userPackage->save();
                $userPackage = UserPackage::with(['plan', 'user'])->find($userPackage->id);


                /* if(!isset($Oldpayload)) {

                 } else {
                     Log::info('old package');
                     $userPackage = UserPackage::with(['plan', 'user'])->find($Oldpayload['old_package']);
                 }*/
                if(isset($incoming['variables']['price_for_customer'])) {
                    $priceForCustomer = $incoming['variables']['price_for_customer'];
                }else{
                    $priceForCustomer =0;
                }

                $vatDetails = Countries::where('country_code','DK')->orderBy('id','desc')->first();
                $percentTotal = ($priceForCustomer * $vatDetails->vat_rate)/100;
                $totals = $priceForCustomer+$percentTotal;

                $subscription = QuickpaySubscriptions::updateOrCreate(
                    ['created_user_id' => $userID, 'user_package' => $userPackage->id, 'order_id' => $payload['order_id'], 'priceForCommission' => $totals],
                    $payload
                );



                if ($operationsPay['qp_status_code'] == "20000" || $operationsPay['qp_status_code'] == "30100") {
                    return $this->createrecurring($userPackage, (isset($Oldpayload) ? $Oldpayload : false), $amount, $priceForCustomer);
                }
            }

        }

        if (isset($incoming['id']) && Str::startsWith($incoming['order_id'], 'gsub')) {
            Log::info('Gift Subscription Update');
            $payload = [];
            $payload['subscription_id'] = $incoming['id'];
            $payload['order_id'] = $incoming['order_id'];
            $payload['created_at'] = Carbon::parse($incoming['created_at'])->toDateTimeString();
            $payload['updated_at'] = Carbon::parse($incoming['updated_at'])->toDateTimeString();
            $payload['metadata'] = json_encode($incoming['metadata']);
            $payload['link'] = $incoming['link']['url'];
            $payload['agreement_id'] = $incoming['link']['agreement_id'];
            $payload['amount'] = $incoming['link']['amount'];
            $payload['payment_methods'] = $incoming['link']['payment_methods'];
            $payload['accepted'] = ($incoming['accepted'] == true) ? 'Yes' : 'No';
            //$payload['created_user_id'] = $incoming['variables']['user_id'];
            $payload['operations'] = json_encode($incoming['operations']);
            $payload['package'] = $incoming['variables']['package'];
            $payload['state'] = $incoming['state'];
            if(isset($incoming['variables']['user_id'])) {
                $createdUserId = $incoming['variables']['user_id'];
            }
            if(isset($incoming['variables']['receiver_id'])) {
                $receverUserId = $incoming['variables']['receiver_id'];
            }
            $amount = $incoming['link']['amount'];


            $operationsPay = end($incoming['operations']);

            Log::info('Operations...');
            Log::info(json_encode($payload));
            $packageInfo = Package::find($payload['package']);

            if (isset($packageInfo->id)) {
                Log::info('new package');
                $userPackage = UserPackage::updateOrCreate(
                    ['created_user_id'=>$receverUserId, 'subscription_id'=>$payload['subscription_id'], 'package_id'=>$packageInfo->id]
                    ,[
                    'subscription_id'=>$payload['subscription_id'],
                    'package_id' => $packageInfo->id,
                    'starts_at' => Carbon::now()->toDateTimeString(),
                    'state' => 'Awaiting Payment Confirmation',
                    'status' => 'inactive',
                    'ends_at' => Carbon::now()->add($packageInfo->invoice_period, $packageInfo->invoice_interval)->toDateTimeString(),
                    'created_user_id' => $receverUserId,
                    'updated_user_id' => $receverUserId,
                ]);
                //$userPackage->subscription_id = $payload['subscription_id'];
                $userPackage->save();
                $userPackage = UserPackage::with(['plan', 'user'])->find($userPackage->id);


                /* if(!isset($Oldpayload)) {

                 } else {
                     Log::info('old package');
                     $userPackage = UserPackage::with(['plan', 'user'])->find($Oldpayload['old_package']);
                 }*/
                if(isset($incoming['variables']['price_for_customer'])) {
                    $priceForCustomer = $incoming['variables']['price_for_customer'];
                }else{
                    $priceForCustomer =0;
                }
                $subscription = QuickpaySubscriptions::updateOrCreate(
                    ['created_user_id' =>$receverUserId, 'user_package' => $userPackage->id, 'order_id' => $payload['order_id'], 'priceForCommission' => $priceForCustomer],
                    $payload
                );

                if ($operationsPay['qp_status_code'] == "20000" || $operationsPay['qp_status_code'] == "30100") {
                    return $this->creategiftrecurring($userPackage, (isset($Oldpayload) ? $Oldpayload : false), $amount, $priceForCustomer);
                }
            }

        }

        if (isset($incoming['id']) && Str::startsWith($incoming['order_id'], 'ivrec')) {

            Log::info('Recurring Update');
            $payload = [];
            $payload['recurring_id'] = $incoming['id'];
            $payload['subscription_id'] = $incoming['subscription_id'];
            $payload['order_id'] = $incoming['order_id'];
            $payload['created_at'] = Carbon::parse($incoming['created_at'])->toDateTimeString();
            $payload['updated_at'] = Carbon::parse($incoming['updated_at'])->toDateTimeString();
            $payload['metadata'] = json_encode($incoming['metadata']);
            $payload['link'] = $incoming['link']['url'];
            $payload['agreement_id'] = $incoming['link']['agreement_id'];
            $payload['amount'] = $incoming['link']['amount'];
            $payload['payment_methods'] = $incoming['link']['payment_methods'];
            $payload['accepted'] = ($incoming['accepted'] == true) ? 'Yes' : 'No';
            $payload['operations'] = json_encode($incoming['operations']);


            $payload['state'] = $incoming['state'];
            $operationsPay = end($incoming['operations']);
            if (!empty($payload['subscription_id']) && $payload['state']=='processed') {
                Log::info('---- Recieved Recurring CallBack ---- Processing Payments');
                return $this->checkpayments($payload);
            } else {
                Log::info('---- no proceed Payments');
                Log::info(json_encode($incoming));
            }

        }
        if (isset($incoming['id']) && Str::startsWith($incoming['order_id'], 'grec')) {

            Log::info('Gift Recurring Update');
            $payload = [];
            $payload['recurring_id'] = $incoming['id'];
            $payload['subscription_id'] = $incoming['subscription_id'];
            $payload['order_id'] = $incoming['order_id'];
            $payload['created_at'] = Carbon::parse($incoming['created_at'])->toDateTimeString();
            $payload['updated_at'] = Carbon::parse($incoming['updated_at'])->toDateTimeString();
            $payload['metadata'] = json_encode($incoming['metadata']);
            $payload['link'] = $incoming['link']['url'];
            $payload['agreement_id'] = $incoming['link']['agreement_id'];
            $payload['amount'] = $incoming['link']['amount'];
            $payload['payment_methods'] = $incoming['link']['payment_methods'];
            $payload['accepted'] = ($incoming['accepted'] == true) ? 'Yes' : 'No';
            $payload['operations'] = json_encode($incoming['operations']);


            $payload['state'] = $incoming['state'];
            $operationsPay = end($incoming['operations']);
            if (!empty($payload['subscription_id']) && $payload['state']=='processed') {
                Log::info('---- Recieved Recurring CallBack ---- Processing Payments');
                return $this->checkgiftpayments($payload);
            } else {
                Log::info('---- no proceed Payments');
                Log::info(json_encode($incoming));
            }

        }



        if (isset($incoming['id']) && Str::startsWith($incoming['order_id'], 'ivcsub')) {
            Log::info('Company Subscription Update');
            $payload = [];
            $payload['subscription_id'] = $incoming['id'];
            $payload['order_id'] = $incoming['order_id'];
            $payload['created_at'] = Carbon::parse($incoming['created_at'])->toDateTimeString();
            $payload['updated_at'] = Carbon::parse($incoming['updated_at'])->toDateTimeString();
            $payload['metadata'] = json_encode($incoming['metadata']);
            $payload['link'] = $incoming['link']['url'];
            $payload['agreement_id'] = $incoming['link']['agreement_id'];
            $payload['amount'] = $incoming['link']['amount'];
            $payload['payment_methods'] = $incoming['link']['payment_methods'];
            $payload['accepted'] = ($incoming['accepted'] == true) ? 'Yes' : 'No';
            $payload['operations'] = json_encode($incoming['operations']);
            $payload['company_id'] = $incoming['variables']['company'];
            $payload['vat'] = $incoming['variables']['vat_rate'];
            $payload['state'] = $incoming['state'];
            $userID = $incoming['variables']['user_id'];

            $operationsPay = end($incoming['operations']);

            Log::info('Operations...');
            Log::info(json_encode($payload));

            $companyInfo = Createcompany::find($payload['company_id']);

            Log::info('COMPANY INFOR: '.json_encode($companyInfo));

            Log::info('COMPANY INFOR: '.json_encode($companyInfo->agreed_price));
            if (isset($companyInfo->company_id)) {
                Log::info('New Company added: ');
                $userCompany = UserCompanies::updateOrCreate(
                    ['created_user_id'=>$userID, 'subscription_id'=>$payload['subscription_id'], 'company_id'=>$companyInfo->company_id]
                    ,[
                    'subscription_id'=>$payload['subscription_id'],
                    'company_id' => $companyInfo->company_id,
                    'starts_at' => Carbon::parse($companyInfo->contract_start_date)->toDateTimeString(),
                    'state' => 'Awaiting Payment Confirmation',
                    'contract_amount' => $payload['amount'],
                    'status' => 'inactive',
                    'ends_at' => Carbon::parse($companyInfo->contract_end_date)->toDateTimeString(),
                    'created_user_id' => $userID,
                    'updated_user_id' => $userID,
                    'company_hash' => bcrypt($companyInfo->company_id),
                    'agreed_members' => $incoming['variables']['agreed_members']

                ]);



                Log::info('COMPANY SAVE '.json_encode($userCompany));

                $userCompany->save();
                $subscription = CompanyQuickpaySubscriptions::updateOrCreate(
                    ['created_user_id' => $userID, 'company_id' => $userCompany->company_id, 'order_id' => $payload['order_id']],
                    $payload
                );

                $data['amount'] = $incoming['link']['amount'];
                $data['company_id'] = $userCompany->company_id;
                $data['company_id'] = $userCompany->company_id;

                //$this->checkCompanyPayments($payload);

                if ($operationsPay['qp_status_code'] == "20000" || $operationsPay['qp_status_code'] == "30100") {
                    return $this->createRecurringCompany($userCompany, (isset($data) ? $data : false));
                }
            }

        }

        if (isset($incoming['id']) && Str::startsWith($incoming['order_id'], 'crec')) {

            Log::info('Recurring Company Update');
            $payload = [];
            $payload['recurring_id'] = $incoming['id'];
            $payload['subscription_id'] = $incoming['subscription_id'];
            $payload['order_id'] = $incoming['order_id'];
            $payload['created_at'] = Carbon::parse($incoming['created_at'])->toDateTimeString();
            $payload['updated_at'] = Carbon::parse($incoming['updated_at'])->toDateTimeString();
            $payload['metadata'] = json_encode($incoming['metadata']);
            $payload['link'] = $incoming['link']['url'];
            $payload['agreement_id'] = $incoming['link']['agreement_id'];
            $payload['amount'] = $incoming['link']['amount'];
            $payload['payment_methods'] = $incoming['link']['payment_methods'];
            $payload['accepted'] = ($incoming['accepted'] == true) ? 'Yes' : 'No';
            $payload['operations'] = json_encode($incoming['operations']);


            $payload['state'] = $incoming['state'];
            $operationsPay = end($incoming['operations']);
            if (!empty($payload['subscription_id']) && $payload['state']=='processed') {
                Log::info('---- Recieved Recurring CallBack ---- Processing Company Payments');
                return $this->checkCompanyPayments($payload);
            } else {
                Log::info('---- no proceed Payments Company');
                Log::info(json_encode($incoming));
            }

        }

    }

    public function createSubscription($data)
    {
        Log::info('===================================================================================================');

        Log::info('Creating Subscription');
        try {
            $client = new QuickPay(':' . env('QUICKPAY_API_USER'));

            $orderID = "ivsub" . $data['user']->id . time();

            //Create payment

            $userDetails = User::with('coachInfo')->find($data['user']->id);
            $vatDetails = Countries::where('country_code','DK')->orderBy('id','desc')->first();
            $postData = ['user_id' => $data['user']->id, 'package' => $data['packageInfo']->id];

            if (isset($data['old_package']) && isset($data['upgrade_package']) && isset($data['new_plan_id'])) {
                $postData['old_package'] = $data['old_package'];
                $postData['upgrade_package'] = $data['upgrade_package'];
                $postData['new_plan_id'] = $data['new_plan_id'];
            }

            $postData['price_for_customer'] = $data['packageInfo']->price_for_customer;

            $subscription = $client->request->post('/subscriptions', [
                'order_id' => $orderID,
                'currency' => 'dkk',
                'description' => 'Iviggo - ' . $data['packageInfo']->title,
                'invoice_address' => ['name' => $data['user']->first_name . ' ' . $data['user']->last_name, 'email' => $data['user']->email],
                'variables' => $postData,
            ]);
            Log::info('CreateSub - 1st');

            if ($subscription->httpStatus() === 201) {
                Log::info('CreateSub - 2nd - 200 from QP');
                $subscriptionObject = $subscription->asObject();

                $endpoint = sprintf("/subscriptions/%s/link", $subscriptionObject->id);

                Log::info('CreateSub - 3d - QP link Generation');
                $encryptedStr = Crypt::encryptString($data['user']->id . '**' . $orderID . '**recurring');

                $packagePrice = $data['packageInfo']->price_for_customer*$data['packageInfo']->invoice_period;
                if($data['packageInfo']->price_for_customer ==''){
                    $packagePrice = $data['packageInfo']->price*$data['packageInfo']->invoice_period;
                }else {
                    $packagePrice = $data['packageInfo']->price_for_customer;
                }

                Log::info('Package Price'.$packagePrice);
                $percentTotal = ($packagePrice * $vatDetails->vat_rate)/100;
                $totals = $packagePrice+$percentTotal;


                //Issue a put request to create payment link
                $link = $client->request->put($endpoint, [
                    "amount" => $packagePrice * 100,
                    "language" => 'da',
                    "framed" => true,
                    "continue_url" => route('payment.success', ['token' => $encryptedStr]),
                    "cancel_url" => route('payment.fail', ['token' => $encryptedStr]),
                    "callback_url" => route('payment.info')
                ]);

                if ($link->httpStatus() === 200) {
                    Log::info('CreateSub - 4th - 200 from QP link Generation');
                    $subscriptionLink = $link->asObject()->url;

                    session(['qp_link' => $subscriptionLink]);

                    return redirect()->away($subscriptionLink);
                }


            }
        } catch (\Exception $e) {
            echo $e->getMessage();
        }
    }

    public function cGiftSub($data){
        print $data;exit;
        exit('sasasaas');
    }

    public function createGiftSubscription($data)
    {
        Log::info('===================================================================================================');
        Log::info('Creating Gift Subscription');
        try {
            $client = new QuickPay(':' . env('QUICKPAY_API_USER'));

            $orderID = "gsub" . $data['giftUser']->id. time();

            //Create payment
            $postData = ['receiver_id' => $data['giftUser']->id, 'user_id' => $data['user']->id, 'package' => $data['packageInfo']->id];

            $subscription = $client->request->post('/subscriptions', [
                'order_id' => $orderID,
                'currency' => 'dkk',
                'description' => 'Iviggo - ' . $data['packageInfo']->title,
                'variables' => $postData,
            ]);

            GiftCard::create([
                'user_id' => $data['user']->id,
                'receiver_id' => $data['giftUser']->id,
                'package_id' =>$data['packageInfo']->id
            ]);

            Log::info('CreateSub - 1st');
            Log::info($subscription->httpStatus());
            if ($subscription->httpStatus() === 201) {
                Log::info('CreateSub - 2nd - 200 from QP');
                $subscriptionObject = $subscription->asObject();

                $endpoint = sprintf("/subscriptions/%s/link", $subscriptionObject->id);

                Log::info('CreateSub - 3d - QP link Generation');
                $encryptedStr = Crypt::encryptString($orderID . '**recurring');

                $packagePrice = $data['packageInfo']->price*$data['packageInfo']->invoice_period;
                $totals = $packagePrice;


                //Issue a put request to create payment link
                $link = $client->request->put($endpoint, [
                    "amount" => $totals * 100,
                    "language" => 'da',
                    "framed" => true,
                    "continue_url" => route('payment.gift.success', ['token' => $encryptedStr, 'packageId' => $data['packageInfo']->id, 'uId'=> $data['giftUser']->id, 'user_id' => $data['user']->id]),
                    "cancel_url" => route('payment.fail', ['token' => $encryptedStr]),
                    "callback_url" => route('payment.info')
                ]);

                if ($link->httpStatus() === 200) {
                    Log::info('CreateSub - 4th - 200 from QP link Generation');
                    $subscriptionLink = $link->asObject()->url;

                    session(['qp_link' => $subscriptionLink]);

                    return redirect()->away($subscriptionLink);
                }

            }
        } catch (\Exception $e) {
            echo $e->getMessage();
        }
    }

    public function createCompanySubscription($data)
    {


        Log::info('===================================================================================================');

        Log::info('Creating Company Subscription');

        Log::info(json_encode($data['company']));


        try {
            $client = new QuickPay(':' . env('QUICKPAY_API_USER'));

            $orderID = "ivcsub" . $data['company']->company_id . time();

            Log::info('CreateSub - 1st'. json_encode($orderID));

            $userDetails = User::with('coachInfo')->find($data['company']->coach_id);
            $vatDetails = Countries::where('country_code',$data['company']->country)->orderBy('id','desc')->first();
            $postData = ['user_id' => $data['company']->coach_id, 'company' => $data['company']->company_id, 'agreed_members' => $data['company']->agreed_members, 'vat_rate'=>$vatDetails->vat_rate];


            //Create payment

            $subscription = $client->request->post('/subscriptions', [
                'order_id' => $orderID,
                'currency' => 'dkk',
                'description' => 'Iviggo - ' . $data['company']->company_name,
                'invoice_address' => ['name' => $data['company']->owner_first_name . ' ' . $data['company']->owner_last_name, 'email' => $data['company']->owner_email],
                'variables' => $postData,
            ]);
            Log::info('CreateSub - 1st');

            if ($subscription->httpStatus() === 201) {
                Log::info('Create Company Sub - 2nd - 200 from QP');
                $subscriptionObject = $subscription->asObject();

                $endpoint = sprintf("/subscriptions/%s/link", $subscriptionObject->id);

                Log::info('Create Company Sub - 3d - QP link Generation');
                $encryptedStr = Crypt::encryptString($data['company']->company_id . '**' . $orderID . '**recurring');


                $packagePrice = $data['companyInfo']['agreed_price'];
                $percentTotal = ($packagePrice * $vatDetails->vat_rate)/100;
                $totals = $packagePrice+$percentTotal;

                //$totals = $data['companyInfo']['agreed_price'];

                //Issue a put request to create payment link
                $link = $client->request->put($endpoint, [
                    "amount" => $totals,
                    "language" => 'da',
                    "framed" => true,
                    "continue_url" => route('payment.success', ['token' => $encryptedStr]),
                    "cancel_url" => route('payment.fail', ['token' => $encryptedStr]),
                    "callback_url" => route('payment.info')
                ]);

                if ($link->httpStatus() === 200) {
                    Log::info('Create Company Sub - 4th - 200 from QP link Generation');
                    $subscriptionLink = $link->asObject()->url;

                    Log::info('Company Sub Link:      '.$subscriptionLink);
                    session(['qp_link' => $subscriptionLink]);

                    return redirect()->away($subscriptionLink);
                }

            }else{
                Log::info('error: '.$subscription->httpStatus());
            }
        } catch (\Exception $e) {
            echo $e->getMessage();
        }
    }


    public function createrecurring(userPackage $userPackage, $data = false, $amount, $priceForCustomer)
    {

        Log::info('Recurring -- Recieved Data');
        Log::info(json_encode($data));
        Log::info('AMOUNT RENEWED'. $amount);

        $orderID = $userPackage->user->id . time();
        $subscriptionID = $userPackage->subscription_id;
        $userID = $userPackage->user->id;


        Log::info('Recurring Start / Payments');
        $client = new QuickPay(':' . env('QUICKPAY_API_USER'));

        $subInfo = QuickpaySubscriptions::where('subscription_id', $subscriptionID)->first();
        if ($subInfo->state == 'cancelled') {
            return redirect()->route('user.payments');
        }


        Log::info('Rec - 1st - Creating Rec Request');
        if($data && isset($data['new_plan_id'])) {
            $newPackage = Package::find($data['new_plan_id']);
        }
        Log::info('Rec - 1/2 - all new');

        $userDetails = User::with('coachInfo')->find($userID);
        $vatDetails = Countries::where('country_code',$userDetails->coachInfo->country)->orderBy('id','desc')->first();


        // If Old Subscription is Renewed
        if($amount == '' && $priceForCustomer == '') {
            $packagePrice = $userPackage->plan->price*$userPackage->plan->invoice_period;
            $percentTotal = ($packagePrice * $vatDetails->vat_rate)/100;
            $amount = $packagePrice+$percentTotal;
        }
        Log::info('Create recurring'. $amount);
        // If Old Subscription is Renewed


        $recurring = $client->request->post('/subscriptions/' . $subscriptionID . '/recurring', [
            'order_id' => "ivrec" . $orderID,
            'amount' => $amount,
            'auto_capture' => true
        ]);



        if ($recurring->httpStatus() === 202) {
            Log::info('Rec - 2nd - 200 from QP recurring');

            $recurringInfo = $recurring->asObject();
            QuickpayRecurring::updateOrCreate(
                ['created_user_id' => $userID, 'subscription_id' => $recurringInfo->subscription_id, 'order_id' => $recurringInfo->order_id],
                ['recurring_id' => $recurringInfo->id
                    , 'accepted' => $recurringInfo->accepted
                    , 'type' => $recurringInfo->type
                    , 'currency' => $recurringInfo->currency
                    , 'state' => $recurringInfo->state
                    , 'metadata' => json_encode($recurringInfo->metadata)
                    , 'operations' => json_encode($recurringInfo->operations)
                ]
            );

            if(Auth::check()) {
                $encryptedStr = Crypt::encryptString($userID . '**' . $orderID . '**recurring');
                return redirect()->route('payment.success', ['token' => $encryptedStr]);

            } else {
                return 'success';
            }

            //$this->checkpayments(['subscription_id' => $recurringInfo->subscription_id,'state' => $recurringInfo->state]);

            //$this->checkpayments(['subscription_id' => $recurringInfo->subscription_id]);
        } else {
            Log::info('Rec - 5th - Recuring Failed');
            if(isset($newPackage)) {

                $userPackage = UserPackage::create([
                    'package_id' => $newPackage->id,
                    'state' => 'Error',
                    'status' => 'inactive',
                    'created_user_id' => $userID,
                    'updated_user_id' => $userID,
                ]);
                $userPackage->subscription_id = $subscriptionID;
                $userPackage = UserPackage::find($userPackage->id);
            }

            if ($recurring->httpStatus() == 400 || $recurring->httpStatus() == 403) {
                $userPackage->state = 'Not Authorized';
                $userPackage->canceled_at = Carbon::now()->toDateTimeString();
                $userPackage->cancels_at = Carbon::now()->toDateTimeString();
            } else {
                $userPackage->state = 'Invalid Request';
                $userPackage->canceled_at = Carbon::now()->toDateTimeString();
                $userPackage->cancels_at = Carbon::now()->toDateTimeString();
            }
            $userPackage->save();



            $subScriptionUpdate = $client->request->get('/subscriptions/' . $subscriptionID)->asArray();
            Log::info('Sub Details - '.json_encode($subScriptionUpdate));

            $payload = [];
            if (isset($subScriptionUpdate['state'])) {
                $payload['state'] = $subScriptionUpdate['state'];
                $payload['operations'] = json_encode($subScriptionUpdate['operations']);

                QuickpaySubscriptions::updateOrCreate(
                    ['created_user_id' => $userID, 'subscription_id' => $subscriptionID, 'order_id' => $subScriptionUpdate['order_id'], 'priceForCommission' => $priceForCustomer],
                    $payload
                );
            }

            //Mail::to($userPackage->user->email)->send(new PaymentError($userPackage, $userPackage->state));


        }
    }

    public function creategiftrecurring(userPackage $userPackage, $data = false, $amount, $priceForCustomer)
    {

        Log::info('Recurring -- Recieved Data');
        Log::info(json_encode($data));
        Log::info('HERE IN GIFT RECURRINH');
        Log::info('User package: '.json_encode($data));
        Log::info('AMOUNT RENEWED'. $amount);

        $orderID = $userPackage->user->id . time();
        $subscriptionID = $userPackage->subscription_id;
        $userID = $userPackage->user->id;


        Log::info('Recurring Start / Payments');
        $client = new QuickPay(':' . env('QUICKPAY_API_USER'));

        $subInfo = QuickpaySubscriptions::where('subscription_id', $subscriptionID)->first();
        if ($subInfo->state == 'cancelled') {
            return redirect()->route('user.payments');
        }


        Log::info('Rec - 1st - Creating Rec Request');
        if($data && isset($data['new_plan_id'])) {
            $newPackage = Package::find($data['new_plan_id']);
        }
        Log::info('Rec - 1/2 - all new');

        /*        $userDetails = User::with('coachInfo')->find($userID);
                $vatDetails = Countries::where('country_code',$userDetails->coachInfo->country)->orderBy('id','desc')->first();*/


        // If Old Subscription is Renewed
        if($amount == '' && $priceForCustomer == '') {
            $amount = $userPackage->plan->price*$userPackage->plan->invoice_period;
            //$percentTotal = ($packagePrice * $vatDetails->vat_rate)/100;
            //$amount = $packagePrice+$percentTotal;
        }
        Log::info('Create recurring'. $amount);
        // If Old Subscription is Renewed


        $recurring = $client->request->post('/subscriptions/' . $subscriptionID . '/recurring', [
            'order_id' => "grec" . $orderID,
            'amount' => $amount,
            'auto_capture' => true
        ]);



        if ($recurring->httpStatus() === 202) {
            Log::info('Rec - 2nd - 200 from QP recurring');

            $recurringInfo = $recurring->asObject();
            QuickpayRecurring::updateOrCreate(
                ['created_user_id' => $userID, 'subscription_id' => $recurringInfo->subscription_id, 'order_id' => $recurringInfo->order_id],
                ['recurring_id' => $recurringInfo->id
                    , 'accepted' => $recurringInfo->accepted
                    , 'type' => $recurringInfo->type
                    , 'currency' => $recurringInfo->currency
                    , 'state' => $recurringInfo->state
                    , 'metadata' => json_encode($recurringInfo->metadata)
                    , 'operations' => json_encode($recurringInfo->operations)
                ]
            );

            if(Auth::check()) {
                $encryptedStr = Crypt::encryptString($userID . '**' . $orderID . '**recurring');
                return redirect()->route('payment.gift.success', ['token' => $encryptedStr]);

            } else {
                return 'success';
            }

            //$this->checkpayments(['subscription_id' => $recurringInfo->subscription_id,'state' => $recurringInfo->state]);

            //$this->checkpayments(['subscription_id' => $recurringInfo->subscription_id]);
        } else {
            Log::info('Rec - 5th - Recuring Failed');
            if(isset($newPackage)) {

                $userPackage = UserPackage::create([
                    'package_id' => $newPackage->id,
                    'state' => 'Error',
                    'status' => 'inactive',
                    'created_user_id' => $userID,
                    'updated_user_id' => $userID,
                ]);
                $userPackage->subscription_id = $subscriptionID;
                $userPackage = UserPackage::find($userPackage->id);
            }

            if ($recurring->httpStatus() == 400 || $recurring->httpStatus() == 403) {
                $userPackage->state = 'Not Authorized';
                $userPackage->canceled_at = Carbon::now()->toDateTimeString();
                $userPackage->cancels_at = Carbon::now()->toDateTimeString();
            } else {
                $userPackage->state = 'Invalid Request';
                $userPackage->canceled_at = Carbon::now()->toDateTimeString();
                $userPackage->cancels_at = Carbon::now()->toDateTimeString();
            }
            $userPackage->save();



            $subScriptionUpdate = $client->request->get('/subscriptions/' . $subscriptionID)->asArray();
            Log::info('Sub Details - '.json_encode($subScriptionUpdate));

            $payload = [];
            if (isset($subScriptionUpdate['state'])) {
                $payload['state'] = $subScriptionUpdate['state'];
                $payload['operations'] = json_encode($subScriptionUpdate['operations']);

                QuickpaySubscriptions::updateOrCreate(
                    ['created_user_id' => $userID, 'subscription_id' => $subscriptionID, 'order_id' => $subScriptionUpdate['order_id'], 'priceForCommission' => $priceForCustomer],
                    $payload
                );
            }

            //Mail::to($userPackage->user->email)->send(new PaymentError($userPackage, $userPackage->state));


        }
    }


    public function createRecurringCompany($userCompany, $data)
    {


        Log::info('Recurring -- Received Company Data');
        Log::info(json_encode($userCompany));

        $orderID = $userCompany->user->id . time();
        $subscriptionID = $userCompany->subscription_id;
        $userID = $userCompany->user->id;



        Log::info('Recurring Start / Payments');
        $client = new QuickPay(':' . env('QUICKPAY_API_USER'));

        $subInfo = CompanyQuickpaySubscriptions::where('subscription_id', $subscriptionID)->first();
        if ($subInfo->state == 'cancelled') {
            return redirect()->route('user.payments');
        }


        Log::info('Rec - 1st - Creating Rec Request');

        $totals = $data['amount'];

        $userDetails = User::with('coachInfo')->find($userID);
        $vatDetails = Countries::where('country_code','DK')->orderBy('id','desc')->first();
        /*        $packagePrice = $userPackage->plan->price*$userPackage->plan->invoice_period;
                $percentTotal = ($packagePrice * $vatDetails->vat_rate)/100;
                $totals = $packagePrice+$percentTotal;*/

        $recurring = $client->request->post('/subscriptions/' . trim($subscriptionID) . '/recurring', [
            'order_id' => "crec" . $orderID,
            'amount' => $totals,
            'auto_capture' => true
        ]);


        $companyInfo = UserCompanies::where('company_id', $data['company_id'])->first();


        if ($recurring->httpStatus() === 202) {
            Log::info('Rec - 2nd - 200 from QP recurring');

            $recurringInfo = $recurring->asObject();
            QuickpayRecurring::updateOrCreate(
                ['created_user_id' => $userID, 'subscription_id' => $recurringInfo->subscription_id, 'order_id' => $recurringInfo->order_id],
                ['recurring_id' => $recurringInfo->id
                    , 'accepted' => $recurringInfo->accepted
                    , 'type' => $recurringInfo->type
                    , 'currency' => $recurringInfo->currency
                    , 'state' => $recurringInfo->state
                    , 'metadata' => json_encode($recurringInfo->metadata)
                    , 'operations' => json_encode($recurringInfo->operations)
                ]
            );

            if(Auth::check()) {
                $encryptedStr = Crypt::encryptString($userID . '**' . $orderID . '**recurring');
                return redirect()->route('payment.success', ['token' => $encryptedStr]);

            } else {
                return 'success';
            }
        } else {
            Log::info('Rec - 5th - Recuring Failed');


            if ($recurring->httpStatus() == 400 || $recurring->httpStatus() == 403) {
                $companyInfo->state = 'Not Authorized';
                $companyInfo->canceled_at = Carbon::now()->toDateTimeString();
                $companyInfo->cancels_at = Carbon::now()->toDateTimeString();
            } else {
                $companyInfo->state = 'Invalid Request';
                $companyInfo->canceled_at = Carbon::now()->toDateTimeString();
                $companyInfo->cancels_at = Carbon::now()->toDateTimeString();
            }
            $companyInfo->save();



            $subScriptionUpdate = $client->request->get('/subscriptions/' . $subscriptionID)->asArray();
            Log::info('Sub Details - '.json_encode($subScriptionUpdate));

            $payload = [];
            if (isset($subScriptionUpdate['state'])) {
                $payload['state'] = $subScriptionUpdate['state'];
                $payload['operations'] = json_encode($subScriptionUpdate['operations']);

                CompanyQuickpaySubscriptions::updateOrCreate(
                    ['created_user_id' => $userID, 'subscription_id' => $subscriptionID, 'order_id' => $subScriptionUpdate['order_id']],
                    $payload
                );
            }

            //Mail::to($userPackage->user->email)->send(new PaymentError($userPackage, $userPackage->state));


        }
    }



    public function checkCompanyPayments($payload)
    {
        Log::info('+++++++++++++++++++++++++++++++++++');
        Log::info('++    Check Company Payments Function    ++');
        Log::info('+++++++++++++++++++++++++++++++++++');
        $client = new QuickPay(':' . env('QUICKPAY_API_USER'));

        $userCompany= UserCompanies::orderBy('id', 'desc')->with(['plan'])->where(['subscription_id'=>$payload['subscription_id'],'status'=>'inactive'])->first();
        Log::info('Pay Load: '.json_encode($userCompany));
        //dd($userCompany);
        if (isset($userCompany->id)) {

            Log::info('++    Company   ++');
            Log::info('Pay Load: '.json_encode($payload));
            $userID = $userCompany->created_user_id;
            Log::info('User Id: '.$userID);
            Log::info('Payments - 1st - QP payment check');
            //sleep(5);
            $paymentsReq = $client->request->get('/subscriptions/' . $payload['subscription_id'] . '/payments')->asArray();
            Log::info('Payment Request: '.json_encode($paymentsReq));
            $paymentControl = $paymentsReq[0];
            $operationalMessage = end($paymentControl['operations']);

            $subDetails = CompanyQuickpaySubscriptions::where('subscription_id',$paymentControl['subscription_id'])->first();



            Log::info('UPDATING COMPANY PARAMETERS');
            Log::info($userCompany->company_id);
            if ($paymentControl['accepted'] == true && $operationalMessage['type'] == 'capture') {
                $qPayment = CompanyQuickpayPayments::updateOrCreate(
                    ['order_id' => $paymentControl['order_id']
                        , 'subscription_id' => $paymentControl['subscription_id']
                        , 'created_user_id' => $userID
                        , 'company_id' => $userCompany->id
                        , 'vat' => $subDetails->vat
                    ],
                    ['payment_id' => $paymentControl['id']
                        , 'accepted' => $paymentControl['accepted']
                        , 'type' => $paymentControl['type']
                        , 'currency' => $paymentControl['currency']
                        , 'state' => $operationalMessage['qp_status_msg']
                        , 'metadata' => json_encode($paymentControl['metadata'])
                        , 'operations' => json_encode($paymentControl['operations'])
                        , 'balance' => $paymentControl['balance']
                        , 'amount' => $userCompany->contract_amount
                    ]
                );
                Log::info('Payments - 2nd - payment processing');

                $sendMail = false;


                if ($operationalMessage['qp_status_code'] == null || empty($operationalMessage['qp_status_code'])) {

                    $userCompany->state = 'Awaiting Payment Confirmation';
                    $userCompany->save();

                } elseif ($operationalMessage['qp_status_code'] == "20000") {


                    $paymentDetails = CompanyQuickpayPayments::where('subscription_id',$paymentControl['subscription_id'])->first();
                    Log::info('Payment Details: '.json_encode($paymentDetails));
                    $companyInfo = Createcompany::find($userCompany->company_id);
                    $paymentDetails->contract_start_date = Carbon::parse($companyInfo->contract_start_date)->toDateTimeString();
                    $paymentDetails->contract_end_date = Carbon::parse($companyInfo->contract_end_date)->toDateTimeString();
                    $paymentDetails->agreed_members = $userCompany->agreed_members;
                    $paymentDetails->save();

                    Log::info('Payments - 3rd - Updating New Company');
                    $userCompany->starts_at = Carbon::parse($userCompany->starts_at)->toDateTimeString();
                    $userCompany->ends_at = Carbon::parse($userCompany->ends_at)->toDateTimeString();
                    if ($userCompany->state != $operationalMessage['qp_status_msg']) {
                        $sendMail = true;
                    }
                    $userCompany->state = $operationalMessage['qp_status_msg'];
                    $userCompany->status = 'active';
                    $userCompany->save();

                    // Commission Distribution For Company

                    $userData = User::with(['coachInfo'])->find($userID);

                    Log::info('USER COMPANY INFO: '.$userData->coachInfo->country);
                    //$commisionInfo = $this->commissionCompany($userData, $userCompany);
                    $vatInfo = Countries::where('country_code',$companyInfo->country)->orderBy('id','desc')->first();
                    // $vatInfo = Countries::where('country_code', $userData->coachInfo->country)->orderBy('id', 'desc')->first();


                    if ($sendMail) {
                        $adminEmails = User::role('superadmin')->pluck('email');
                        $countOld = UserCompanies::orderBy('id', 'desc')->where(['created_user_id' => $userCompany->created_user_id, 'subscription_id' => $userCompany->subscription_id])->count();
                        if ($countOld > 1) {

                            Mail::to($userCompany->user->email)->send(new CompanyPaymentProcessed($userCompany, $qPayment, $vatInfo, $userData, 'yes'));
                            Mail::to($adminEmails)->send(new CompanyPaymentProcessed($userCompany, $qPayment, $vatInfo, $userData, 'yes'));
                            Mail::to($companyInfo->company_email)->send(new CompanyPaymentProcessed($userCompany, $qPayment, $vatInfo, $userData, 'yes'));
                            Mail::to($companyInfo->owner_email)->send(new CompanyPaymentProcessed($userCompany, $qPayment, $vatInfo, $userData, 'yes'));

                            Mail::to($userCompany->user->email)->send(new CompanyEmployeesEmail($userCompany, $companyInfo, $userData));
                            Mail::to($adminEmails)->send(new CompanyEmployeesEmail($userCompany,  $companyInfo, $userData));
                            Mail::to($companyInfo->company_email)->send(new CompanyEmployeesEmail($userCompany, $companyInfo, $userData));
                            Mail::to($companyInfo->owner_email)->send(new CompanyEmployeesEmail($userCompany, $companyInfo, $userData));

                        } else {
                            Mail::to($userCompany->user->email)->send(new CompanyPaymentProcessed($userCompany, $qPayment, $vatInfo, $userData));
                            Mail::to($adminEmails)->send(new CompanyPaymentProcessed($userCompany, $qPayment, $vatInfo, $userData));
                            Mail::to($companyInfo->company_email)->send(new CompanyPaymentProcessed($userCompany, $qPayment, $vatInfo, $userData));
                            Mail::to($companyInfo->owner_email)->send(new CompanyPaymentProcessed($userCompany, $qPayment, $vatInfo, $userData));

                            Mail::to($userCompany->user->email)->send(new CompanyEmployeesEmail($userCompany, $companyInfo, $userData));
                            Mail::to($adminEmails)->send(new CompanyEmployeesEmail($userCompany,  $companyInfo, $userData));
                            Mail::to($companyInfo->company_email)->send(new CompanyEmployeesEmail($userCompany, $companyInfo, $userData));
                            Mail::to($companyInfo->owner_email)->send(new CompanyEmployeesEmail($userCompany, $companyInfo, $userData));
                        }

                    }


                } else{

                    $userCompany->state = $operationalMessage['qp_status_msg'];
                    $userCompany->save();

                    Log::info('Payments - 5th - Error Payments');
                    if ($payload['state'] != 'pending') {

                        Mail::to($userCompany->user->email)->send(new PaymentError($userCompany, $userCompany->state));
                    }

                }
            }
            Log::info('+++++++++++++++++++++++++++++++++++');
            return 'success';

        } else {
            Log::info('++  No Company Found  ++');
        }

    }


    public function checkpayments($payload)
    {

        Log::info('+++++++++++++++++++++++++++++++++++');
        Log::info('++    Check Payments Function    ++');
        Log::info('+++++++++++++++++++++++++++++++++++');
        $client = new QuickPay(':' . env('QUICKPAY_API_USER'));

        $userPackage = UserPackage::orderBy('id', 'desc')->with(['plan'])->where(['subscription_id'=>$payload['subscription_id'],'status'=>'inactive'])->first();

        if (isset($userPackage->id)) {

            $old_package = UserPackage::orderBy('id', 'desc')->where(['created_user_id'=>$userPackage->created_user_id,'status'=>'active','state'=>'Approved'])->first();

            Log::info('++    Found Package    ++');

            $userID = $userPackage->user->id;
            Log::info('Payments - 1st - QP payment check');
            //sleep(5);
            $paymentsReq = $client->request->get('/subscriptions/' . $payload['subscription_id'] . '/payments')->asArray();
            $paymentControl = $paymentsReq[0];
            Log::info('Payment Control: '.json_encode($paymentControl));

            $operationalMessage = end($paymentControl['operations']);

            $subDetails = QuickpaySubscriptions::where('subscription_id',$paymentControl['subscription_id'])->first();
            Log::info('SUB DETAILS: '.json_encode($subDetails));
            if($subDetails->priceForCommission == 0){
                $paymentamount = $userPackage->plan->price*$userPackage->plan->invoice_period;
            }else{
                $paymentamount = $subDetails->priceForCommission;
            }
            if ($paymentControl['accepted'] == true && $operationalMessage['type'] == 'capture') {
                $qPayment = QuickpayPayments::updateOrCreate(
                    ['order_id' => $paymentControl['order_id']
                        , 'subscription_id' => $paymentControl['subscription_id']
                        , 'created_user_id' => $userID
                        , 'user_package' => $userPackage->id
                        , 'vat' => $subDetails->vat
                    ],
                    ['payment_id' => $paymentControl['id']
                        , 'accepted' => $paymentControl['accepted']
                        , 'type' => $paymentControl['type']
                        , 'currency' => $paymentControl['currency']
                        , 'state' => $operationalMessage['qp_status_msg']
                        , 'metadata' => json_encode($paymentControl['metadata'])
                        , 'operations' => json_encode($paymentControl['operations'])
                        , 'balance' => $paymentControl['balance']
                        , 'amount' => $paymentamount//$userPackage->plan->price*$userPackage->plan->invoice_period
                    ]
                );
                Log::info('Payments - 2nd - payment processing');

                $sendMail = false;


                if ($operationalMessage['qp_status_code'] == null || empty($operationalMessage['qp_status_code'])) {

                    $userPackage->state = 'Awaiting Payment Confirmation';
                    $userPackage->save();

                } elseif ($operationalMessage['qp_status_code'] == "20000") {

                    if($old_package && isset($old_package->id) && $old_package->id!=$userPackage->id) {
                        Log::info('Payments - 3rd - Upgrading Old and New Package');
                        $userPackage->starts_at= (Carbon::parse($old_package->ends_at)->diffInDays(Carbon::now(), false) >= 0) ? Carbon::now()->toDateTimeString() : $old_package->starts_at;

                        $newPackageEndStart = (Carbon::parse($old_package->ends_at)->diffInDays(Carbon::now(),false) >= 0) ? Carbon::now()->toDateTimeString() : $old_package->ends_at;

                        $userPackage->ends_at = Carbon::parse($newPackageEndStart)->add($userPackage->plan->invoice_period, $userPackage->plan->invoice_interval)->toDateTimeString();

                        $old_package->status = 'inactive';
                        $userPackage->recurring = $old_package->recurring;
                        $old_package->save();

                        Log::info('**** Old Package ****');
                        Log::info(json_encode($old_package));

                        Log::info('**** New Package ****');
                        Log::info(json_encode($userPackage));



                        if($old_package->subscription_id != $userPackage->subscription_id) {
                            $cancelOld = $client->request->post('/subscriptions/'.$old_package->subscription_id.'/cancel');
                            if ($cancelOld->httpStatus() === 202) {
                                Log::info('Old Subscription Cancelled');
                            }
                        }
                    } else {
                        Log::info('Payments - 3rd - Updating New Package');
                        $userPackage->starts_at = Carbon::now()->toDateTimeString();
                        $userPackage->ends_at = Carbon::now()->add($userPackage->plan->invoice_period, $userPackage->plan->invoice_interval)->toDateTimeString();
                    }



//                if ($data && isset($data['upgrade']) && $data['upgrade'] == true) {
//                    $oldSub = UserPackage::find($data['oldSub']);
//                    if (isset($oldSub->id)) {
//                        $userPackage->starts_at = $oldSub->ends_at;
//                        $userPackage->ends_at = Carbon::parse($oldSub->ends_at)->add($userPackage->plan->invoice_period, $userPackage->plan->invoice_interval)->toDateTimeString();
//                    }
//                }
                    if ($userPackage->state != $operationalMessage['qp_status_msg'])  {
                        $sendMail = true;
                    }
                    $userPackage->state = $operationalMessage['qp_status_msg'];
                    $userPackage->status = 'active';
                    $userPackage->save();

                    // Commission Distribution

                    $userData = User::with(['coachInfo'])->find($userID);
                    Log::info('USER DATA: '.$userData);



                    $userPackage['plan']['priceForCommission'] = $subDetails->priceForCommission;
                    Log::info('USER PACKAGE: '.json_encode($userPackage));
                    //$commisionInfo = $this->commission($userData,$userPackage);
                    $vatInfo = Countries::where('country_code',$userData->coachInfo->country)->orderBy('id','desc')->first();


                    if ($sendMail)  {

                        $countOld = UserPackage::orderBy('id', 'desc')->where(['created_user_id'=>$userPackage->created_user_id,'subscription_id'=>$userPackage->subscription_id])->count();
                        if($countOld > 1) {

                            Mail::to($userPackage->user->email)->send(new PaymentProcessed($userPackage,$qPayment, $vatInfo,$userData,'yes'));
                        } else {
                            Mail::to($userPackage->user->email)->send(new PaymentProcessed($userPackage,$qPayment, $vatInfo,$userData));
                        }

                    }


                } else {


                    $userPackage->state = $operationalMessage['qp_status_msg'];
                    $userPackage->save();

                    Log::info('Payments - 5th - Error Payments');
                    if($payload['state']!='pending') {

                        Mail::to($userPackage->user->email)->send(new PaymentError($userPackage, $userPackage->state));
                    }



                }
            }
            Log::info('+++++++++++++++++++++++++++++++++++');
            return 'success';

        } else {
            Log::info('++  No Package Found  ++');
        }

    }
    public function checkgiftpayments($payload)
    {

        Log::info('+++++++++++++++++++++++++++++++++++');
        Log::info('++    Check Payments Function    ++');
        Log::info('+++++++++++++++++++++++++++++++++++');
        $client = new QuickPay(':' . env('QUICKPAY_API_USER'));

        $userPackage = UserPackage::orderBy('id', 'desc')->with(['plan'])->where(['subscription_id'=>$payload['subscription_id'],'status'=>'inactive'])->first();

        if (isset($userPackage->id)) {

            $old_package = UserPackage::orderBy('id', 'desc')->where(['created_user_id'=>$userPackage->created_user_id,'status'=>'active','state'=>'Approved'])->first();

            Log::info('++    Found Package    ++');

            $userID = $userPackage->user->id;
            Log::info('Payments - 1st - QP payment check');
            //sleep(5);
            $paymentsReq = $client->request->get('/subscriptions/' . $payload['subscription_id'] . '/payments')->asArray();
            $paymentControl = $paymentsReq[0];
            Log::info('Payment Control: '.json_encode($paymentControl));

            $operationalMessage = end($paymentControl['operations']);

            $subDetails = QuickpaySubscriptions::where('subscription_id',$paymentControl['subscription_id'])->first();
            Log::info('SUB DETAILS: '.json_encode($subDetails));
            if($subDetails->priceForCommission == 0){
                $paymentamount = $userPackage->plan->price*$userPackage->plan->invoice_period;
            }else{
                $paymentamount = $subDetails->priceForCommission;
            }
            if ($paymentControl['accepted'] == true && $operationalMessage['type'] == 'capture') {
                $qPayment = QuickpayPayments::updateOrCreate(
                    ['order_id' => $paymentControl['order_id']
                        , 'subscription_id' => $paymentControl['subscription_id']
                        , 'created_user_id' => $userID
                        , 'user_package' => $userPackage->id
                        , 'vat' => $subDetails->vat
                    ],
                    ['payment_id' => $paymentControl['id']
                        , 'accepted' => $paymentControl['accepted']
                        , 'type' => $paymentControl['type']
                        , 'currency' => $paymentControl['currency']
                        , 'state' => $operationalMessage['qp_status_msg']
                        , 'metadata' => json_encode($paymentControl['metadata'])
                        , 'operations' => json_encode($paymentControl['operations'])
                        , 'balance' => $paymentControl['balance']
                        , 'amount' => $paymentamount//$userPackage->plan->price*$userPackage->plan->invoice_period
                    ]
                );
                Log::info('Payments - 2nd - payment processing');

                $sendMail = false;


                if ($operationalMessage['qp_status_code'] == null || empty($operationalMessage['qp_status_code'])) {

                    $userPackage->state = 'Awaiting Payment Confirmation';
                    $userPackage->save();

                } elseif ($operationalMessage['qp_status_code'] == "20000") {

                    if($old_package && isset($old_package->id) && $old_package->id!=$userPackage->id) {
                        Log::info('Payments - 3rd - Upgrading Old and New Package');
                        $userPackage->starts_at= (Carbon::parse($old_package->ends_at)->diffInDays(Carbon::now(), false) >= 0) ? Carbon::now()->toDateTimeString() : $old_package->starts_at;

                        $newPackageEndStart = (Carbon::parse($old_package->ends_at)->diffInDays(Carbon::now(),false) >= 0) ? Carbon::now()->toDateTimeString() : $old_package->ends_at;

                        $userPackage->ends_at = Carbon::parse($newPackageEndStart)->add($userPackage->plan->invoice_period, $userPackage->plan->invoice_interval)->toDateTimeString();
                        $userPackage->validity_date = Carbon::now()->addYears(2)->toDateTimeString();

                        $old_package->status = 'inactive';
                        $userPackage->recurring = $old_package->recurring;
                        $old_package->save();

                        Log::info('**** Old Package ****');
                        Log::info(json_encode($old_package));

                        Log::info('**** New Package ****');
                        Log::info(json_encode($userPackage));



                        if($old_package->subscription_id != $userPackage->subscription_id) {
                            $cancelOld = $client->request->post('/subscriptions/'.$old_package->subscription_id.'/cancel');
                            if ($cancelOld->httpStatus() === 202) {
                                Log::info('Old Subscription Cancelled');
                            }
                        }
                    } else {
                        Log::info('Payments - 3rd - Updating New Package');
                        $userPackage->starts_at = Carbon::now()->toDateTimeString();
                        $userPackage->ends_at = Carbon::now()->add($userPackage->plan->invoice_period, $userPackage->plan->invoice_interval)->toDateTimeString();
                        $userPackage->validity_date = Carbon::now()->addYears(2)->toDateTimeString();
                    }



//                if ($data && isset($data['upgrade']) && $data['upgrade'] == true) {
//                    $oldSub = UserPackage::find($data['oldSub']);
//                    if (isset($oldSub->id)) {
//                        $userPackage->starts_at = $oldSub->ends_at;
//                        $userPackage->ends_at = Carbon::parse($oldSub->ends_at)->add($userPackage->plan->invoice_period, $userPackage->plan->invoice_interval)->toDateTimeString();
//                    }
//                }
                    if ($userPackage->state != $operationalMessage['qp_status_msg'])  {
                        $sendMail = true;
                    }
                    $userPackage->state = $operationalMessage['qp_status_msg'];
                    $userPackage->status = 'inactive';
                    $userPackage->save();

                    // Commission Distribution

                    $userData = User::with(['coachInfo'])->find($userID);
                    Log::info('USER DATA: '.$userData);



                    $userPackage['plan']['priceForCommission'] = $subDetails->priceForCommission;
                    Log::info('USER PACKAGE: '.json_encode($userPackage));
                    //$commisionInfo = $this->commission($userData,$userPackage);
                    // $vatInfo = Countries::where('country_code',$userData->coachInfo->country)->orderBy('id','desc')->first();


                    /*    if ($sendMail)  {

                            $countOld = UserPackage::orderBy('id', 'desc')->where(['created_user_id'=>$userPackage->created_user_id,'subscription_id'=>$userPackage->subscription_id])->count();
                            if($countOld > 1) {

                                Mail::to($userPackage->user->email)->send(new PaymentProcessed($userPackage,$qPayment, $vatInfo,$userData,'yes'));
                            } else {
                                Mail::to($userPackage->user->email)->send(new PaymentProcessed($userPackage,$qPayment, $vatInfo,$userData));
                            }

                        }*/


                } else {


                    $userPackage->state = $operationalMessage['qp_status_msg'];
                    $userPackage->save();

                    Log::info('Payments - 5th - Error Payments');
                    if($payload['state']!='pending') {

                        Mail::to($userPackage->user->email)->send(new PaymentError($userPackage, $userPackage->state));
                    }



                }
            }
            Log::info('+++++++++++++++++++++++++++++++++++');
            return 'success';

        } else {
            Log::info('++  No Package Found  ++');
        }

    }

    public function callback(Request $request)
    {
        $incoming = $request->getContent();
        Log::info($incoming);

        $incoming = $request->all();
        Log::info('With Request All' . $incoming);
    }

    public function commission(User $userData,UserPackage $userPackage)
    {
        $allChilds = $userData->coachInfo->getAllParents();
        Log::info('Commisions - Members');
        Log::info(json_encode($allChilds));
        Log::info(json_encode($userPackage));

        $adminUsers = User::role('superadmin')->first();
        Log::info(json_encode($adminUsers));
        $adminUsersCode = Arr::pluck($adminUsers, 'coachInfo.invite_code');

        $coachPercentage = config('iviggo.speaker_pool');
        $simonPercentage = config('iviggo.simon_payout');

        if($userPackage->status=='active' && $userPackage->state=='Approved') {
            if($userPackage->priceForCommission){
                $totalAmount = ($userPackage->priceForCommission);
            }else{
                $totalAmount = ($userPackage->plan->priceForCommission);
            }
            $currentDate = Carbon::parse($userPackage->updated_at);
            Log::info('Price For Commission: COMMISSION'. $totalAmount);

            if($userPackage->status=='active' && $userPackage->state=='Approved') {
                $commission = new Commissions();
                $commission->price = $totalAmount;
                $commission->commission = ($totalAmount*($simonPercentage['percentage']/100));
                $commission->percentage =  $simonPercentage['percentage'];
                $commission->package_id = null;
                $commission->user_package_id = null;
                $commission->partner_id = $adminUsers->id;
                $commission->created_user_id = $userPackage->user->id;
                $commission->updated_user_id = $userPackage->user->id;
                $commission->status = 'approved';
                $commission->save();

            }


            return true;
        } else {
            return false;
        }

    }

    public function commissionCompany(User $userData,UserCompanies $userCompany) {
        $allChilds = $userData->coachInfo->getAllCompanyParents();
        $coachPercentage = config('iviggo.speaker_pool');
        $simonPercentage = config('iviggo.simon_payout');

        Log::info('Commisions - Company');
        Log::info(json_encode($allChilds));


        $adminUsers = User::role('superadmin')->with('coachInfo')->get('id');
        Log::info(json_encode($adminUsers));

        $adminUsersCode = Arr::pluck($adminUsers,'coachInfo.invite_code');

        if($userCompany->status=='active' && $userCompany->state=='Approved') {
            $totalAmount = ($userCompany->plan->agreed_price);
            if(isset($allChilds['coach']) && count($allChilds['coach'])>0 && $totalAmount>0) {
                foreach($allChilds['coach'] as $partner) {
                    if($userCompany->status=='active' && $userCompany->state=='Approved' && empty($partner->user->deleted_at)) {
                        $commission = new Commissions();
                        $commission->price = $totalAmount;
                        $commission->commission = ($totalAmount*($coachPercentage['percentage']/100));
                        $commission->percentage = $coachPercentage['percentage'];
                        $commission->package_id = null;
                        $commission->user_package_id = null;
                        $commission->partner_id = $partner->user->id;
                        $commission->created_user_id = $userCompany->user->id;
                        $commission->updated_user_id = $userCompany->user->id;
                        $commission->status = 'approved';
                        $commission->save();


                    }
                }
            }

            if(isset($allChilds['superadmin']) && count($allChilds['superadmin'])>0 && $totalAmount>0) {
                foreach($allChilds['superadmin'] as $partner) {
                    if($userCompany->status=='active' && $userCompany->state=='Approved' && empty($partner->user->deleted_at)) {
                        $commission = new Commissions();
                        $commission->price = $totalAmount;
                        $commission->commission = ($totalAmount*($simonPercentage['percentage']/100));
                        $commission->percentage =  $simonPercentage['percentage'];
                        $commission->package_id = null;
                        $commission->user_package_id = null;
                        $commission->partner_id = $partner->user->id;
                        $commission->created_user_id = $userCompany->user->id;
                        $commission->updated_user_id = $userCompany->user->id;
                        $commission->status = 'approved';
                        $commission->save();

                    }
                }
            }


            return true;
        } else {
            return false;
        }

    }

}


/*Log::info('Rec - 3rd - QP payment check');
            $paymentsReq = $client->request->get('/subscriptions/' . $subscriptionID . '/payments')->asArray();
            $paymentControl = end($paymentsReq);

            Log::info(json_encode($paymentControl));


            QuickpayPayments::updateOrCreate(
                ['order_id' => $paymentControl['order_id']
                    , 'subscription_id' => $paymentControl['subscription_id']
                    , 'created_user_id' => $userID
                ],
                ['payment_id' => $paymentControl['id']
                    , 'accepted' => $paymentControl['accepted']
                    , 'type' => $paymentControl['type']
                    , 'currency' => $paymentControl['currency']
                    , 'state' => (empty($paymentControl['state']) || $paymentControl['state']==null) ? 'Awaiting Payment Confirmation' : $paymentControl['state']
                    , 'metadata' => json_encode($paymentControl['metadata'])
                    , 'operations' => json_encode($paymentControl['operations'])
                    , 'balance' => $paymentControl['balance']
                ]
            );

            $operationalMessage = end($paymentControl['operations']);
            Log::info('Rec - 4th - payment processing');

            $sendMail = false;
            if ($userPackage->state != $operationalMessage['qp_status_msg']) {
                $userPackage->state = $operationalMessage['qp_status_msg'];
                $userPackage->save();
                $sendMail = true;
            }

            if ($operationalMessage['qp_status_code'] == null || empty($operationalMessage['qp_status_code'])) {

                $userPackage->state = 'Awaiting Payment Confirmation';
                $userPackage->save();

            }elseif ($operationalMessage['qp_status_code'] == "20000") {

                $userPackage->starts_at = Carbon::now()->toDateTimeString();
                $userPackage->ends_at = Carbon::now()->add($userPackage->plan->invoice_period, $userPackage->plan->invoice_interval)->toDateTimeString();


//                if ($data && isset($data['upgrade']) && $data['upgrade'] == true) {
//                    $oldSub = UserPackage::find($data['oldSub']);
//                    if (isset($oldSub->id)) {
//                        $userPackage->starts_at = $oldSub->ends_at;
//                        $userPackage->ends_at = Carbon::parse($oldSub->ends_at)->add($userPackage->plan->invoice_period, $userPackage->plan->invoice_interval)->toDateTimeString();
//                    }
//                }

                $userPackage->status = 'active';
                $userPackage->save();
                if ($sendMail) {
                    Mail::to($userPackage->user->email)->send(new PaymentProcessed($userPackage));
                }
                return 'success';
            } else {
                Log::info('Rec - 4th - Error Payments');

                if ($sendMail) {
                    Mail::to($userPackage->user->email)->send(new PaymentError($userPackage, $userPackage->state));
                }
            }
            return 'error';*/
