<?php

namespace App\Http\Controllers\Member;

use App\CoachProfileInfo;
use App\Http\Controllers\Controller;
use App\Package;
use App\UserPackage;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Auth;
use Spatie\Permission\Traits\HasRoles;


class PaymentHistoryController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */

    protected $user;
    use HasRoles;

    public function __construct()
    {
        // $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */


    public function index() {

        $this->user = Auth::user();


        $q = function($q) {
            $q->orderBy('id', 'desc')->with(['quickpayPayments' => function ($query) {
                $query->orderBy('id', 'desc');
            }]);
        };
        $data['record'] = UserPackage::with(['user','plan','quickpaySubscription'=>$q])->where(['created_user_id'=>$this->user->id])->whereIn('status',['active','expired'])->orderBy('id', 'desc')->first();

        if(!isset($data['record']->id)) {
            return redirect()->route('user.renew_package');
        }

        $data['packages'] = Package::where(['visible'=>'yes'])->get();
        return view('member/payments',$data);

    }
}
