<?php

namespace App\Http\Controllers;


use App\CoachCompanyEmployee;
use App\CoachProfileInfo;
use App\Countries;
use App\Createcompany;
use App\GiftCard;
use App\GiftPackages;
use App\Mail\CompanyRegistration;
use App\Mail\GiftEmail;
use App\Mail\GiftSuccess;
use App\Mail\Verification;
use App\Package;
use App\User;
use App\UserCompanies;
use App\UserPackagePrices;
use App\UserPackage;
use FFMpeg\Media\Gif;
use Illuminate\Http\Request;
use Auth;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Spatie\Permission\Traits\HasRoles;
use App\Http\Controllers\PaymentController;
use Carbon\Carbon;

class GiftController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */

    protected $user;
    use HasRoles;

    public function __construct()
    {
        // $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */


    public function index(Request $request)
    {
        $data['packages'] = GiftPackages::where(['visible'=>'yes'])->get();
        return view('pages.giftjoin', $data);
    }

    protected function validator(array $data)
    {
        $validator = Validator::make($data, [
            'user' => 'required|array',
            'user.first_name' => 'required|min:2|max:40',
            'user.last_name' => 'required|min:2|max:80',
            'user.email' => 'required|email|unique:users,email'
        ],
            ['user.first_name' => 'First Name',
                'user.last_name' => 'Last name',
                'user.email' => 'Email',
            ]);
        return $validator;
    }

    protected function validatorgift(array $data)
    {
        $validator = Validator::make($data, [
            'giftuser' => 'required|array',
            'giftuser.password' => 'required|min:8|max:30|confirmed|secure_password',
            'giftuser.unique_code' => 'regex:/^[a-zA-Z0-9]+$/|nullable',/*
            'giftuser.invitation_code' => 'required|unique:coach_profile,invite_code|regex:/^[a-zA-Z0-9]+$/',*/
            'giftuser.country' => 'required|alpha_spaces',

        ], [
            'giftuser.unique_code.regex' => 'The Referral Invitation Code field must have valid characters and without spaces.',/*
        'giftuser.invitation_code.unique' => 'The Invitation Code is already in use. Please enter unique invite code.',*/
        ]);
        return $validator;
    }

    public function giftcreate(Request $request)
    {
        $this->user = Auth::user();
        $loggedInUser = $this->user;
        $package = $request->id;
        $packageInfo = Package::find($package);
        $paymentController = new PaymentController();
        $guest = User::create([
            'first_name' => '',
            'last_name' => '',
            'email' => Str::random(3).'giftuser'.'@yopmail.com',
            'password' => '123456',
            'new_password_token' => Str::random(40),
            'status' => 'inactive',
            'verification_code'=>substr(md5(rand()),0,7),
        ]);

        $guest->assignRole('user');

        return $paymentController->createGiftSubscription(['user'=>$loggedInUser,'packageInfo' => $packageInfo, 'giftUser' => $guest]);
    }


    public function receiverDetails(Request $request)
    {
        return view('pages.user_gift_signup');
    }

    public function submitgift(Request $request)
    {
        $this->validator($request->all())->validate();
        $this->submit = $request->input('submit');
        $userProfile = $request->user;
        $user = User::where(['id'=>$userProfile['userId']])->first();
        $sUser = User::where(['id'=>$userProfile['senderId']])->first();
        $sUseremail = $sUser['email'];
        $user['email'] = $userProfile['email'];
        $user['first_name'] = $userProfile['first_name'];
        $user['last_name'] = $userProfile['last_name'];
        $user['verification_code']= substr(md5(rand()),0,7);
        $user->save();
        $user['user_id'] = $userProfile['userId'];

        $userPackage = $userProfile['packageId'];

        if($userProfile['packageId'] == 1){
            $userpackage = '1';
        }else if($userProfile['packageId'] == 2){
            $userpackage = '3';
        }else if($userProfile['packageId'] == 3){
            $userpackage = '12';
        }

        $user['package_id'] = $userpackage;
        Mail::to($userProfile['email'])->send(new GiftEmail($user));
        Mail::to($sUseremail)->send(new GiftEmail($user));
        return view('home');

    }

    public function gusersignup(Request $request)
    {

        $checkGiftUser =  UserPackage::with(['user'=> function  ($q) use($request) {
            $q->where(['status'=>'inactive','id'=>$request->user_id]);
        }])->where(['status'=>'inactive','created_user_id'=>$request->user_id,'cancels_at'=>NULL, 'canceled_at'=>NULL])
            ->whereDate('validity_date', '>', Carbon::now()->toDateTimeString())->first();
        if(!is_null($checkGiftUser)){
            $countries = Countries::pluck('country_name','country_code')->toArray();
            return view('pages.giftuser_signup', ['countries' => $countries]);
        }
        abort(403, 'The link is expired.');



    }

    public function submit(Request $request)
    {

        $this->validatorgift($request->all())->validate();
        $this->submit = $request->input('submit');

        $giftuser = $request->giftuser;

        $user= User::where(['verification_code'=>$giftuser['unique_code'],'status'=>'inactive'])->first();
        if (!isset($user->id)){
            return back()->with('errmessage', 'Invalid Invitation Code is entered');
        }

        if (isset($user->id)) {
            $user['password'] = bcrypt($giftuser['password']);
            $user['first_name'] = $giftuser['first_name'];
            $user['last_name'] = $giftuser['last_name'];
            $user['email'] = $giftuser['email'];
            $giftuser['mobile'] = $giftuser['mobile'];
            $giftuser['country'] = $giftuser['country'];
            $user['status'] = 'active';
            $user->save();
            $userPackage = UserPackage::where(['created_user_id'=>$user->id,'status'=>'inactive'])->first();
            if (isset($userPackage)) {
                $updatePackage = UserPackage::where(['created_user_id'=>$user->id,'status'=>'inactive'])->update(
                    array('starts_at' => Carbon::now()->toDateTimeString(),
                        'ends_at'=>Carbon::now()->add($userPackage->plan->invoice_period,$userPackage->plan->invoice_interval)->toDateTimeString(),
                        'status'=>'active'));
            }

            $senderDetails= GiftCard::where(['receiver_id'=>$user->id])->first();
            $senderUser = User::with(['coachInfo'])->find($senderDetails->user_id);
            $this->default_condition = ["created_user_id" => $user->id, "updated_user_id" => $user->id];
            $giftuser['referral_invite_code'] = $senderUser->coachInfo->invite_code;
            /*$giftuser['invite_code'] = $giftuser['invitation_code'];*/
            CoachProfileInfo::updateOrCreate($this->default_condition, $giftuser);
            $adminEmails = User::role('superadmin')->pluck('email');
            Mail::to($senderUser->email)->send(new GiftSuccess($user, $senderUser));
            /*   Mail::to($adminEmails)->send(new GiftSuccess($user, $senderUser));*/
            return back();


        }

    }


}
