<?php

namespace App\Http\Controllers\Company;

use App\CoachCompanyEmployee;
use App\CoachProfileInfo;
use App\Countries;
use App\Createcompany;
use App\Http\Controllers\Controller;
use App\Http\Controllers\PaymentController;
use App\Mail\CompanyRegistration;
use App\Mail\Verification;
use App\Package;
use App\User;
use App\UserCompanies;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Auth;

class SignupEmployeeController extends Controller
{
    public function create()
    {
        $countries = Countries::pluck('country_name','country_code')->toArray();
        return view('coaches.company.signup', ['countries' => $countries]);
    }

    protected function validator(array $data)
    {
        $validator = Validator::make($data, [
            'employee.first_name' => 'required|min:2|max:40',
            'employee.last_name' => 'required|min:2|max:80',
            'employee.email' => 'required|email|unique:users,email',
            'employee.password' => 'required|min:8|max:30|secure_password',
            'employee.unique_code' => 'required'
        ],
            ['employee.first_name' => 'First Name',
                'employee.last_name' => 'Last name',
                'employee.email' => 'Email',
                'employee.password' => 'Password',
            ],
            [
                'employee.unique_code' => 'Invitation Code',
                'employee.first_name' => 'Employee First Name',
                'employee.last_name' => 'Employee Last Name',
                'employee.email' => 'Email',
                'employee.password'=> 'Password'

            ]


        );

        return $validator;
    }

    public function submit(Request $request)
    {
        $this->validator($request->all())->validate();
        $this->submit = $request->input('submit');

        $user = $request->employee;

        //$userCompany= UserCompanies::orderBy('id', 'desc')->where(['company_hash'=>$user['unique_code'],'status'=>'active'])->first();
        $userCompany= UserCompanies::orderBy('id', 'desc')->where(['company_hash'=>$user['unique_code'],'status'=>'active'])->limit(1)->first();
        if (!isset($userCompany->company_id)){
            return back()->with('errmessage', 'Invalid Invitation Code is entered');
        }
        $companyData = Createcompany::find($userCompany->company_id);
        $registeredCompanyUsersCount = CoachCompanyEmployee::orderBy('id', 'desc')->where('coach_id',$userCompany->created_user_id)->where('company_id',$userCompany->company_id)->count();
        $totalMembers = $userCompany->agreed_members;


        Log::info('Agreed Members: '.$totalMembers);

        if (isset($userCompany->id) && $registeredCompanyUsersCount < $totalMembers){
            $guest = User::create([
                'first_name' => $user['first_name'],
                'last_name' => $user['last_name'],
                'email' => $user['email'],
                'password' => bcrypt($user['password']),
                'status' => 'active'
            ]);
            $guest->assignRole('companyuser');

            $contactPersonData = User::find($userCompany->created_user_id);
            $companyData = Createcompany::find($userCompany->company_id);
            if($registeredCompanyUsersCount <= $totalMembers) {
                $employeeCoachData = CoachCompanyEmployee::updateOrCreate(
                    ['employee_id' => $guest->id,
                        'coach_id' => $userCompany->created_user_id,
                        'company_id' => $userCompany->company_id,
                        'company_hash' => $userCompany->company_hash
                    ]);
                $employeeCoachData->save();
                $companyData['company_registered_members'] = $registeredCompanyUsersCount+1;
                $pendingMembers = $userCompany->agreed_members - ($registeredCompanyUsersCount+1);

                $companyData['company_pending_members'] = $pendingMembers;
                $companyData['company_total_members'] = $totalMembers;
                $companyData['owner_first_name'] = $companyData['owner_first_name'];
                $companyData['owner_last_name'] = $companyData['owner_last_name'];
                $companyData['employee_email'] = $guest->email;
                $companyData['company_name'] = $companyData['company_name'];
                $adminEmails = User::role('superadmin')->pluck('email');

                Mail::to($companyData['owner_email'] )->send(new CompanyRegistration($companyData));
                Mail::to($companyData['company_email'] )->send(new CompanyRegistration($companyData));
                Mail::to($contactPersonData->email)->send(new CompanyRegistration($companyData));
                Mail::to($adminEmails )->send(new CompanyRegistration($companyData));


                if (isset($guest->id)) {
                    $this->default_condition = ["created_user_id" => $guest->id, "updated_user_id" => $guest->id];
                    CoachProfileInfo::updateOrCreate($this->default_condition, $user);

                    Mail::to($guest->email)->send(new Verification($guest));
                    Mail::to($guest->email)->send(new Verification($guest));
                    if ($request->session()->exists('signup_token')) {
                        $request->session()->forget('signup_token');
                    } else {
                        session(['signup_token' => $guest->new_password_token]);
                    }
                }
                return redirect('login')->with('success', 'Your account is created successfully. You can now login below with your credentials');
                //return view('auth.login')->withErrors(['message' => 'Your account is created successfully. You can now login now below with your credentials']);
            }else{
                //return redirect('login')->with('error', 'Your account is created successfully. You can now login now below with your credentials');
                return back()->with('errmessage' , 'Account registration is failed. Limit is already achieved for this contract. Please use another invitation code');
            }
        }else{
            return back()->with('errmessage', 'Sorry, Employee Signup limit is reached.');
        }



    }

}




