<?php

namespace App\Http\Controllers\Common;

use App\CoachProfileInfo;
use App\Commissions;
use App\Mail\QuestionResponse;
use App\Mail\VideoActive;
use App\Mail\VideoRejected;
use App\Mail\VideoDeleted;
use App\Question;
use App\QuestionReplies;
use Auth;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Countries;
use App\User;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Mail;
use Spatie\Permission\Traits\HasRoles;
use App\Traits\UploadTrait;
use Illuminate\Database\Eloquent\Builder;
use Carbon\Carbon;
use DB;
use App\Video;
use Vimeo;
use App\CoachIntro;
use Illuminate\Support\Arr;
use App\VideoView;






class VideosController extends Controller
{

    protected $user;
    use UploadTrait;
    use HasRoles;

    public function __construct()
    {

    }

    public function video(Request $request)
    {

        $this->validate($request,[
            'id' => 'required|integer',
            'type' => 'required|alpha',
        ]);

        $id = $request->input("id");
        $type = $request->input("type");
        $this->user = Auth::user();
        $code = 200;
        $response = [];

        if(!is_numeric($id) || $id == 0 || strpos($id, "."))
        {

            return response()->json(["message" => "Bad request"], 422);
        }

        if( !in_array($type, ["remove",'approved','reject']) )
        {

            return response()->json(["message" => "Bad request"], 422);
        }



        if($type=='approved')
        {

            $video = Video::with(['user'])->where('id', $id)->where('status', 'pending')->get()->first();
            if(isset($video->id)) {


                $video->status = 'approved';
                $video->save();
                Mail::to($video->user->email)->send(new VideoActive($video));

                $questions = QuestionReplies::where('video_id',$video->id)->get();
                if($questions->count()>0) {
                    foreach($questions as $question) {

                        $appoved = function ( $q){
                            $q->where('status','approved');
                        };

                        $reply = function ( $q) use ($appoved){
                            $q->whereNotNull('video_id')->with(['Video'=>$appoved,'coach'])->whereHas('Video',$appoved);
                        };
                        $qt = Question::with(['Replies'=>$reply])->where('id',$question->question_id)->with('user')->get()->first();

                        Mail::to($qt->user->email)->send(new QuestionResponse($qt));
                    }
                }

            }
            $commission = new Commissions();
            $commission->price = $totalAmount;
            $commission->commission = ($totalAmount*($simonPercentage['percentage']/100));
            $commission->percentage =  $simonPercentage['percentage'];
            $commission->package_id = null;
            $commission->user_package_id = null;
            $commission->partner_id = $video->created_user_id;
            $commission->created_user_id = $video->created_user_id;
            $commission->updated_user_id = $video->created_user_id;
            $commission->status = 'approved';
            $commission->save();
            $response["message"] = "Video is approved.";
        }
        elseif($type=='remove')
        {
            $video = Video::with(['user'])->where('id', $id)->get()->first();

            if(!isset($video->id)) {
                $response["message"] = "Video not found";
                $code = 422;
                return response()->json($response, $code);
            }

            if($this->user->id==$video->created_user_id) {
                $response = Vimeo::request('/videos', ['video_id'=>$video->video_id],'Delete');
                Video::where('id', $id)->delete();
                $response["message"] = "Video is deleted.";
            } elseif($this->user->hasRole('superadmin')) {
                $response = Vimeo::request('/videos', ['video_id'=>$video->video_id],'Delete');
                Video::where('id', $id)->delete();
                $response["message"] = "Video is deleted.";
                Mail::to($video->user->email)->send(new VideoDeleted($video,$request->input("message")));
            } elseif($this->user->hasRole('is_am')) {
                $response = Vimeo::request('/videos', ['video_id'=>$video->video_id],'Delete');
                Video::where('id', $id)->delete();
                $response["message"] = "Video is deleted.";
                Mail::to($video->user->email)->send(new VideoDeleted($video,$request->input("message")));
            }
            $response["message"] = "Video is deleted.";




        }elseif($type=='reject')
        {

            $this->validate($request,[
                'message' => 'required'
            ]);

            $video = Video::with(['user'])->where('id', $id)->get()->first();

            $response = Vimeo::request('/videos', ['video_id'=>$video->video_id],'Delete');
            Video::where('id', $id)->delete();
            Mail::to($video->user->email)->send(new VideoRejected($video,$request->input("message"),$type='video'));

            $response["message"] = "Video is rejected.";
        }
        else
        {
            $response["message"] = "Video not found";
            $code = 422;
        }

        return response()->json($response, $code);

    }

    public function library(Request $request)
    {
        $data = $request->all();
        $this->user = Auth::user();
        if ($this->user->hasRole('user')) {
            $coachId = $this->user->coach_id;
        }else if ($this->user->hasRole('coach')){
            $coachId = $this->user->id;
        }

        $data['categories'] = DB::table('categories')->where('status', 'active')->orderBy('title','asc')->pluck( 'title','id')->toArray();
        $languages = Config::get('iviggo.languages');
        $data['duration'] = [null=>'Newest','2'=>'One Month Old','1'=>'Recent'];

        $userFilter = function ( $q){
            $q->where('status', 'active');
        };

        $videos = Video::with(['user'=>$userFilter])->whereHas('user',$userFilter);

        $filtersOptions  =  $videos->where('status','approved');
        if ($this->user->hasRole('user') || ($this->user->hasRole('coach'))) {
            $filtersOptions = $filtersOptions->where('created_user_id', $coachId)->get();
        }

        $video_languages = array_unique(Arr::pluck($filtersOptions,'language'));
        $data['languages'] = [];
        foreach($video_languages as $key)
        {
            if(array_key_exists($key, $languages))
            {
                $data['languages'][$key] = $languages[$key];
            }
        }
        //return count($data['languages']);
        if(count($data['languages'])==0) {
            $data['languages'] = $languages;
        }

        if(isset($this->user->id)) {
            $data['types'] = [null=>'Søg Efter Præference','2'=>'Medlemskab','1'=>'Favoritter'];

        }

        if(isset($this->user->id)) {
            $videos = $videos->with(['favorites' => function ($q) {
                $q->where('created_user_id', $this->user->id);
            }]);
        }

        if ($request->has('category') && !empty($request->category)) {
            $data['category'] = $request->category;
            $countryFilter = function ( $q) use($request){
                $q->where('category_id', $request->category);
            };
            $videos =$videos->with(['Categories'=>$countryFilter])->whereHas('Categories',$countryFilter);
        }

        if ($request->has('language') && !empty($request->input('language'))) {

            $data['language'] = $request->input('language');

            $videos = $videos->where('language',$request->input('language'));
        }

        if ($request->has('type') && !empty($request->type)) {
            $data['type'] = $request->type;
            if($request->type==2) {
                $subscriptions =  \App\CoachSubscription::where('created_user_id',$this->user->id)->pluck('coach_id');
                $userFilter = function ( $q) use($subscriptions) {
                    $q->whereIn('id', $subscriptions);
                };
                $videos = $videos->with(['user'=>$userFilter])->whereHas('user',$userFilter);
            }

            if($request->type==1) {
                $favorites =  \App\Favorite::where('created_user_id',$this->user->id)->pluck('video_id');
                $videos = $videos->whereIn('id',$favorites);
            }

        }

        $videos =$videos->where('status','approved');

        if ($request->has('state') && !empty($request->state)) {
            $data['state'] = $request->state;
            if($request->state=='2') {
                $videos =$videos->where('created_at','>', Carbon::now()->subDays(30));
            }
            if($request->state=='1') {
                $videos =$videos->where('created_at',Carbon::today());
            }
        }


        $data["videos"] = $videos->inRandomOrder(rand(1,80))->paginate(96);


        //Arr::pluck($filtersOptions,'language');

        //$queries = DB::getQueryLog();

        return view('common.library', $data);
    }

    public function play(Request $request) {
        $this->user = Auth::user();
        $id = $request->route('id');

        if(!is_numeric($id) || $id == 0 || strpos($id, "."))
        {
            return redirect()->back()->with('error', 'Invalid Video Request.');
        }

        $tagsFilter = function ( $q){
            $q->select('tags.id','tags.title');
        };

        $catFilter = function ( $q){
            $q->select('categories.id','categories.title');
        };



        $userFilter = function ( $q){
            $q->where('status', 'active');
        };

        $video = Video::with(['user'=>$userFilter,'Tags'=>$tagsFilter,'Categories'=>$catFilter])->whereHas('user',$userFilter)->where('status','approved');
        if(isset($this->user->id)) {
            $video = $video->with(['favorites' => function ($q) {
                $q->where('created_user_id', $this->user->id);
            }]);
        }

        $video = $video->find($id);



        if(isset($video->id)) {
            $data['categories'] = DB::table('categories')->where('status', 'active')->orderBy('title','asc')->pluck( 'title','id')->toArray();

            $data['user'] = $this->user;
            $data["subscription"] = \App\CoachSubscription::where([
                'coach_id'=>$video->user->id,
                'created_user_id'=>$this->user->id
            ])->get()->count();
            $data['video'] = $video;
            $favorites = function ($q) {
                $q->where('created_user_id', $this->user->id);
            };
            $data['related'] = Video::with(['favorites'=>$favorites,'user'=>$userFilter,'Tags'=>$tagsFilter,'Categories'=>$catFilter])
            ->whereHas('Categories', function ($q) use ($video) {
                return $q->whereIn('title', $video->categories->pluck('title'));
            })
            ->where('id', '!=', $video->id)
            ->whereHas('user',$userFilter)->where('status','approved')
            ->inRandomOrder()
            ->limit('8')
            ->get();

            $data['more'] = Video::with(['favorites'=>$favorites,'user'=>$userFilter,'Tags'=>$tagsFilter,'Categories'=>$catFilter])
            ->whereHas('user', function ($q) use ($video) {
                return $q->where('id', $video->user->id);
            })
            ->where('id', '!=', $video->id)
            ->inRandomOrder()
            ->whereHas('user',$userFilter)->where('status','approved')
            ->limit('8')
            ->get();

            VideoView::createViewLog($video);
        } else {
            return redirect()->back()->with('error', 'Invalid Video Request.');
        }



        return view('pages.video', $data);
    }

    public function index(Request $request)
    {
        $data = $request->all();
        $this->user = Auth::user();
        //$data["user"] = User::with(['coachInfo'])->get();

        $data['categories'] = DB::table('categories')->where('status', 'active')->orderBy('title', 'asc')->pluck('title', 'id')->toArray();
        $languages = Config::get('iviggo.languages');
        $data['duration'] = [null => 'Newest', '2' => 'One Month Old', '1' => 'Recent'];
        $data['statuses'] = [null => 'All', '2' => 'Pending', '1' => 'Approved'];
        $coachTree = new CoachProfileInfo();
        $childUsers = $coachTree->allTree(CoachProfileInfo::where('created_user_id',$this->user->id)->first());

        //return $data;
        $userFilter = function ($q) {
            $q->where('status', 'active');
        };

        if($this->user->hasRole('superadmin')) {
            $videos = Video::with(['user' => $userFilter])->whereHas('user', $userFilter);
        } else {
            $coachTree = new CoachProfileInfo();
            $childUsers = $coachTree->allTree(CoachProfileInfo::where('created_user_id', $this->user->id)->first());
            $videos = Video::with(['user' => $userFilter])->whereHas('user', $userFilter)->whereIn('created_user_id', $childUsers);
        }
        $filtersOptions  =  $videos->get();
        //return $filtersOptions;




        $video_languages = array_unique(Arr::pluck($filtersOptions,'language'));
        $data['languages'] = [];
        foreach($video_languages as $key)
        {
            if(array_key_exists($key, $languages))
            {
                $data['languages'][$key] = $languages[$key];
            }
        }

        if(count($data['languages'])==0) {
            $data['languages'] = $languages;
        }

        if (\Request::segment(1) == 'my') {
            $user = Auth::user();
            $userFilter = function ($q) use($user){
                $q->where('id', $user->id);
            };
            $videos = Video::with(['user' => $userFilter])->whereHas('user', $userFilter);
        }


        if ($request->has('category') && !empty($request->category)) {
            $data['category'] = $request->category;
            $countryFilter = function ( $q) use($request){
                $q->where('category_id', $request->category);
            };
            $videos =$videos->with(['Categories'=>$countryFilter])->whereHas('Categories',$countryFilter);
        }

        if ($request->has('language') && !empty($request->language)) {
            $data['language'] = $request->language;
            $videos =$videos->where('language',$request->language);
        }


        if(isset($this->user->id) && $this->user->hasRole('user') && !$this->user->hasRole('is_am')) {

            $videos =$videos->where('status','approved');
        } else {


            if ($request->has('status') && !empty($request->status)) {
                $data['status'] = $request->status;
                $videos =$videos->where('status',(($request->status=='1') ? 'approved':'pending'));
            }

        }


        if ($request->has('state') && !empty($request->state)) {
            $data['state'] = $request->state;
            if($request->state=='2') {
                $videos =$videos->where('created_at','>', Carbon::now()->subDays(30));
            }
            if($request->state=='1') {
                $videos =$videos->where('created_at',Carbon::today());
            }
        }


        $data["videos"] = $videos->orderBy('created_at', 'desc')->paginate(128);



        //return $data;
        return view('common.video_library', $data);
    }




}
