<?php

namespace App\Http\Controllers\Common;

use App\CoachProfileInfo;
use App\Mail\VideoActive;
use App\Mail\VideoRejected;
use App\Mail\VideoDeleted;
use Auth;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Countries;
use App\User;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Mail;
use Spatie\Permission\Traits\HasRoles;
use App\Traits\UploadTrait;
use Illuminate\Database\Eloquent\Builder;
use Carbon\Carbon;
use DB;
use App\Video;
use Vimeo;
use App\CoachIntro;


class CoachesController extends Controller
{

    protected $user;
    use UploadTrait;
    use HasRoles;

    public function __construct()
    {

    }



    public function index(Request $request)
    {

        $data = $request->all();
        $this->user = Auth::user();
        if ($this->user->hasRole('user')) {
            $coachId = $this->user->coach_id;
        }
        //$data["user"] = User::with(['coachInfo'])->get();


        $countries = Countries::pluck('country_name', 'country_code')->toArray();;
        $data['duration'] = [null => 'Newest', '2' => 'One Month Old', '1' => 'Recent'];


        //return $data;
        $userFilter = function ($q) {
            $q->where('status', 'active');
        };
        // $videos = Video::with(['user'=>$userFilter])->whereHas('user',$userFilter);

        $users = User::role('coach')->where('status', 'active')->select(['id', 'first_name', 'last_name', 'email']);
        if ($this->user->hasRole('user')){
            $users = $users->where('id', $coachId);
         }
        $filtersOptions  =  $users->with('coachInfo')->get();



        $coach_countries = array_unique(Arr::pluck($filtersOptions,'coachinfo.country'));

        $data['countries'] = [];
        foreach($coach_countries as $key)
        {
            if(array_key_exists($key, $countries))
            {
                $data['countries'][$key] = $countries[$key];
            }
        }

        if(count($data['countries'])==0) {
            $data['countries'] = $countries;
        }

        if ($request->has('country') && !empty($request->country)) {
            $data['country'] = $request->country;
            $countryFilter = function ($q) use ($request) {
                $q->where('country', $request->country);
            };
            $users = $users->with(['coachInfo' => $countryFilter])->whereHas('coachInfo', $countryFilter);
        }


        if ($request->has('state') && !empty($request->state)) {
            $data['state'] = $request->state;
            if ($request->state == '2') {
                $users = $users->where('created_at', '>', Carbon::now()->subDays(30));
            }
            if ($request->state == '1') {
                $users = $users->where('created_at', Carbon::today());
            }
        }


        $data["users"] = $users->inRandomOrder(rand(1,64))->paginate(96);
        return view('common.coaches', $data);
    }

    public function profile($id)
    {
        if(!$id || !is_numeric($id))
        {
            return redirect()->route( 'coaches')->with('error','Coach Profile Not Found!');
        }


        $this->user = Auth::user();

        if(isset($this->user->id)) {

            $data["user"] = User::with(['coachInfo'])->where('id', $id)->get(['id', 'first_name', 'last_name', 'email'])->first();
            $data["subscription"] = \App\CoachSubscription::where([
                'coach_id'=>$id,
                'created_user_id'=>$this->user->id
            ])->get()->count();

        } else {
            $data["user"] = User::with(['coachInfo'])->where('id', $id)->get(['id', 'first_name', 'last_name', 'email'])->first();
            $data["subscription"] = \App\CoachSubscription::where([
                'coach_id'=>$id
            ])->get()->count();

        }
        //return $data;
        if(!isset($data['user']->id)) {
            return redirect()->route( 'coaches')->with('error','Coach Profile Not Found!');
        }



        if(!isset($data['user']->id)) {
            return redirect()->route( 'coaches')->with('error','Coach Profile Not Found!');
        }
        //return $data;
        //return $data;
        $data["intro"] = CoachIntro::where(['status'=>'active','created_user_id'=>$id])->get();

        $video = Video::where(['created_user_id'=>$id,'status'=>'approved'])->orderBy('created_at', 'desc');
        if(isset($this->user->id)) {
            $video = $video->with(['favorites' => function ($q) {
                $q->where('created_user_id', $this->user->id);
            }]);
        }

        $data['videos'] = $video->get();
        return view('common.profile', $data);

    }


}
