<?php

namespace App\Http\Controllers\Coach;

use App\Mail\CoachSignup;
use App\Video;
use Auth;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use App\Countries;
use App\User;
use App\CoachProfileInfo;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Spatie\Permission\Traits\HasRoles;
use App\Traits\UploadTrait;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Mail\PasswordUpdate;
use Spatie\Image\Exceptions\InvalidManipulation;
use Spatie\Image\Image;
use Spatie\Image\Manipulations;
use Vimeo\Laravel\Facades\Vimeo;



class DashboardController extends Controller
{

    protected $user;
    use UploadTrait;
    use HasRoles;

    public function __construct()
    {

    }

    public function index(Request $request,$city=false)
    {
        $this->user = Auth::user();


        //return $this->user->id;
        $userFilter = function ( $q){
            $q->where('id', $this->user->id);
        };

        $data["user"] = User::with(['coachInfo','coachIntro','Video'])->where('id', $this->user->id)->get(['id', 'first_name','last_name', 'email'])->first();


        $data['videos'] = Video::where('created_user_id',$this->user->id)->orderBy('created_at', 'desc')->get();




        //return $data;
        return view('bo.pages.profile', $data);
    }

    public function edit(Request $request,$city=false)
    {
        $this->user = Auth::user();
        $data["user"] = User::with(['coachInfo'])->where('id', $this->user->id)->get(['id', 'first_name','last_name', 'email'])->first();
        //return $data;
        $data['countries'] = Countries::pluck('country_name','country_code')->toArray();;


        return view('coaches.editprofile', $data);
    }


    public function update(Request $request)

    {


        $user = Auth::user();
        $userInfo = User::with(['coachInfo'])->where('id', $user->id)->get(['id', 'first_name','last_name', 'email'])->first();

        $this->validate($request,[

            'user_first_name' => 'required|min:2|max:40',
            'user_last_name' => 'required|min:2|max:80',

        ]);


        $user->first_name = $request->input('user_first_name');

        $user->last_name = $request->input('user_last_name');




        $passwordMessage = false;

        if($request->input('user_old_password') && !empty($request->input('user_old_password'))){

            if (!(Hash::check($request->input('user_old_password'), Auth::user()->password))) {
                // The passwords matches
                return redirect()->back()->with("error","Your current password does not matches with the password you provided. Please try again.");
            }

            if(strcmp($request->input('user_new_password'), $request->input('user_old_password')) == 0){
                //Current password and new password are same
                return redirect()->back()->with("error","New Password cannot be same as your current password. Please choose a different password.");
            }

            $this->validate($request,[

                'user_new_password' => 'required|min:8|max:30|confirmed|secure_password',

            ]);



            $user->password = bcrypt($request->input('user_new_password'));

            $passwordMessage = true;



        }

        //$user->save();


        if ($request->has('photo')) {

            $this->validate($request,[

                'photo' =>  'image|mimes:jpeg,png,jpg|max:2048|dimensions:min_width=500,min_height=350',

            ]);
            // Get image file
            $image = $request->file('photo');

            $image_name = time() . '.' . $image->getClientOriginalExtension();

            if (! File::exists(public_path('/uploads/thumbs/'))) {
                File::makeDirectory(public_path('/uploads/thumbs/'));
            }

            if (! File::exists(public_path('/uploads/images/'))) {
                File::makeDirectory(public_path('/uploads/images/'));
            }

            $destinationPath = public_path('/uploads/images/');

            $resize_image = Image::load($image->getRealPath());

            /*$resize_image->fit(Manipulations::FIT_FILL, 270, 270)->background('ffffff')->save($destinationPath . '270_' . $image_name);

            $resize_image->fit(Manipulations::FIT_FILL,470,510)->background('ffffff')->save($destinationPath . '470_' . $image_name);
            $resize_image->fit(Manipulations::FIT_FILL,115,115)->background('ffffff')->save($destinationPath . '115_' . $image_name);*/

            $resize_image->width(470)->save($destinationPath . $image_name);





            $generalInfo['photo'] = $image_name;

        }

        if($request->input('general_country')!=$userInfo->coachInfo->country) {
            $this->validate($request,[
                'general_country' =>  'required|alpha_spaces',
            ]);
            $generalInfo['country'] = $request->input('general_country');
        }


        if($request->input('general_slogan')!=$userInfo->coachInfo->slogan) {
            $this->validate($request,[
                'general_slogan' =>  'required',
            ]);
            $generalInfo['slogan'] = $request->input('general_slogan');
        }

        if($request->input('general_introduction')!=$userInfo->coachInfo->introduction) {
            $this->validate($request,[
                'general_introduction' =>  'required',
            ]);
            $generalInfo['introduction'] = $request->input('general_introduction');
        }

        if($request->input('general_expertise')!=$userInfo->coachInfo->expertise) {
            $this->validate($request,[
                'general_expertise' =>  'required',
            ]);
            $generalInfo['expertise'] = $request->input('general_expertise');
        }

        if($request->input('website')!=$userInfo->coachInfo->website) {
            $this->validate($request,[
                'website' =>  ['required', 'regex:/^(http:\/\/www\.|https:\/\/www\.|http:\/\/|https:\/\/)?[^\.].*\.[a-z]{2,}?(\/.*)?$/'],


            ]);
            $generalInfo['website'] = $request->input('website');
        }

        if($request->input('phone')!=$userInfo->coachInfo->mobile) {
            if($user->marketing_terms=='yes' && $user->marketing_status=='active') {
                $this->validate($request,[
                    'mobile' =>  'required',
                ],[
                'mobile.required' => 'Phone number is required',
                 'mobile.integer' => 'Phone number must be integer value',
                ]);
            } else {
                $this->validate($request,[
                    'mobile' =>  'nullable',
                ], [
                    'mobile.integer' => 'Phone number must be integer value',
                ]);
            }

            $generalInfo['mobile'] = $request->input('phone');
        }

        if($request->input('company')!=$userInfo->coachInfo->company) {

            $this->validate($request,[
                'company' =>  'nullable',
            ]);
            $generalInfo['company'] = $request->input('company');
        }

        if(isset($generalInfo)) {
            $this->default_condition = ["created_user_id" => $user->id, "updated_user_id" => $user->id];

            \App\CoachProfileInfo::updateOrCreate($this->default_condition, $generalInfo);
        }




        $user->save();
        if($passwordMessage) {
            Mail::to($user->email)->send(new PasswordUpdate($user));
        }
        return redirect('/coach/profile')->with('status', 'Profil opdateret!');


    }
}
