<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Spatie\Image\Image;
use Spatie\Image\Manipulations;
use Vimeo\Laravel\Facades\Vimeo;

class CKEditorController extends Controller
{
    public function upload(Request $request)
    {
        if($request->hasFile('upload')) {
            //get filename with extension\

            $image = $request->file('upload');
            $filenamewithextension = $request->file('upload')->getClientOriginalName();

            //get filename without extension

            if (! File::exists(public_path('/uploads/images/'))) {
                File::makeDirectory(public_path('/uploads/images/'));
            }

            $filename = pathinfo($filenamewithextension, PATHINFO_FILENAME);

            //get file extension
            $extension = $request->file('upload')->getClientOriginalExtension();

            //filename to store
            $filenametostore = $filename.'_'.time().'.'.$extension;






            $destinationPath = public_path('/uploads/images/');

            $image->move($destinationPath, $filenametostore);



            //Upload File



            $CKEditorFuncNum = $request->input('CKEditorFuncNum');
            $url = asset('/uploads/images/'.$filenametostore);
            $msg = 'Image successfully uploaded';
            $re = "<script>window.parent.CKEDITOR.tools.callFunction($CKEditorFuncNum, '$url', '$msg')</script>";

            // Render HTML output
            @header('Content-type: text/html; charset=utf-8');
            echo $re;
        }
    }
}
