<?php

namespace App\Http\Controllers\Bo;


use App\CoachProfileInfo;
use App\Commissions;

use App\Exports\PayoutsExport;
use App\Http\Controllers\Controller;
use App\Payouts;
use App\QuickpayPayments;
use App\QuickpaySubscriptions;
use App\SpeakersPool;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Facades\Excel;

use Carbon\Carbon;
use Illuminate\Support\Facades\DB;


use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use App\VideoView;
use App\Video;

class PayoutsController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */

    public function __construct()
    {
        // $this->middleware('auth');
    }

    public function index()
    {
        //$data['totals'] = number_format(QuickpayPayments::where('state','approved')->get()->whereMonth('created_at', '=', '9')/100,2);
        $currentDate = Carbon::now()->addMonth();
        $currentDateString = $currentDate->englishMonth . ', ' . $currentDate->year;
        $oldest = QuickpayPayments::where(['state'=>'Approved','type'=>'Payment'])->orderBy('created_at', 'asc')->first();


        $data = [];
        if (isset($oldest->id)) {

            $startDateTime =Carbon::parse($oldest->created_at);

            while ($startDateTime->englishMonth.', ' .$startDateTime->year!=$currentDateString) {

                $arrKey = $startDateTime->englishMonth . ', ' . $startDateTime->year;

                $totals = 0;
                $data[$arrKey]['month'] =$startDateTime->month;
                $data[$arrKey]['year'] =$startDateTime->year;

                $data[$arrKey]['totals'] = DB::table('quickpay_payments')
                    ->where(['state'=>'Approved','type'=>'Payment'])
                    ->whereMonth('created_at', $startDateTime->month)
                    ->whereYear('created_at', $startDateTime->year)
                    ->sum('amount');

                $data[$arrKey]['totals_2'] = DB::table('company_quickpay_payments')
                    ->where(['state'=>'Approved','type'=>'Payment'])
                    ->whereMonth('created_at', $startDateTime->month)
                    ->whereYear('created_at', $startDateTime->year)
                    ->sum('amount');

                $data[$arrKey]['totals'] = number_format($data[$arrKey]['totals'], 2, '.', '') + number_format($data[$arrKey]['totals_2'], 2, '.', '');

          /*      $data[$arrKey]['payouts'] = DB::table('commissions')
                    ->whereMonth('created_at', $startDateTime->month)
                    ->whereYear('created_at', $startDateTime->year)
                    ->where('type', 'member')
                    ->sum('commission');*/


                $commissionDetails['total_pool_money'] = number_format(($data[$arrKey]['totals'] * config('iviggo.speaker_pool')['percentage']) / 100, 2, '.', '');
                $totalVideosInSystem = Video::withoutTrashed()->where([ 'status' => 'approved'])->orderBy('created_at', 'asc')->count();
                $totalVideosI = Video::withoutTrashed()->where([ 'status' => 'approved'])->orderBy('created_at', 'asc')->get();
                foreach ($totalVideosI as $videoRec){
                    $videos[$videoRec->created_user_id][] = $videoRec->created_user_id;
                }
                $sum = 0;
                foreach ($videos as $k=>$v){
                    $uservideos = Video::withoutTrashed()->where(['created_user_id' => $k, 'status' => 'approved'])->orderBy('created_at', 'asc')->count();
                    $commissionPerVideo= number_format($commissionDetails['total_pool_money']/$totalVideosInSystem,2,'.','');
                    $uservideos * $commissionPerVideo;
                    $sum = $sum + ($uservideos * $commissionPerVideo);
                }
                // FOR SPEAKERS POOL, remove the click logic and add videos logic into the code

                /*$data[$arrKey]['commision_amount'] = DB::table('speakers_pool')
                    ->whereMonth('pool_date', $startDateTime->month)
                    ->whereYear('pool_date', $startDateTime->year)
                    ->sum('amount');*/
                /*$data[$arrKey]['commision_amount'] = number_format($data[$arrKey]['commision_amount'], 2, '.', '');*/



                $data[$arrKey]['commision_amount'] = number_format(($data[$arrKey]['totals'] * config('iviggo.speaker_pool')['percentage']) / 100, 2, '.', '');
                $data[$arrKey]['payouts'] = number_format($sum, 2, '.', '');
                $data[$arrKey]['teo'] = number_format(($data[$arrKey]['totals'] * config('iviggo.teo_payout')['percentage']) / 100, 2, '.', '');
                $data[$arrKey]['simon'] = number_format(($data[$arrKey]['totals'] * config('iviggo.simon_payout')['percentage']) / 100, 2, '.', '');
                $data[$arrKey]['iviggo'] = number_format($data[$arrKey]['totals'] - $data[$arrKey]['payouts'] - $data[$arrKey]['teo'] - $data[$arrKey]['simon']- $data[$arrKey]['commision_amount'], 2, '.', '');


                $startDateTime = $startDateTime->addMonth();
            }

        }
        //return $data;

        $records['data'] = array_reverse($data);


        return view('bo.payouts', $records);
    }

    public function export($month,$year){

        if(!empty($month) && !empty($year) && $month<=12) {


            if($month == '11' && $year == '2021' || $month =='12' && $year == '2021'){
                $peterFlag = 'true';
            }else{
                $peterFlag = 'false';
            }

            return Excel::download(new PayoutsExport($month, $year, $peterFlag), $month . '_' . $year . '.xlsx');

        }

    }

    public function pool()
    {
        $user = Auth::user();
        $currentDate = Carbon::now()/*->addMonth()*/;
        $currentDateString = $currentDate->englishMonth . ', ' . $currentDate->year;

        $oldestRecord = Video::withTrashed()->where(['created_user_id' => $user->id, 'status' => 'approved'])->orderBy('created_at', 'asc')->get();

        $data = [];


        foreach ($oldestRecord as $rec){

            $startDateMonth = $rec->created_at->month;
            $startDateyear = $rec->created_at->year;


          // $arrKey =Carbon::parse($rec->created_at)->englishMonth . ', ' . Carbon::parse($rec->created_at)->year;

            $monthlyvideos = Video::withoutTrashed()->where(['created_user_id' => $user->id, 'status' => 'approved'])->orderBy('created_at', 'asc')/*->whereMonth('created_at', '=', $startDateMonth)->whereYear('created_at', '=', $startDateyear)*/->pluck('id');
            $totalmonthlyvideos = Video::withoutTrashed()->where(['status' => 'approved'])->orderBy('created_at', 'asc')/*->whereMonth('created_at', '=', $startDateMonth)->whereYear('created_at', '=', $startDateyear)*/->get(['id', 'video_title', 'created_user_id', 'created_at','deleted_at']);



            $data['videos'] = 0;
            $data['totals'] = DB::table('quickpay_payments')
                ->where(['state' => 'Approved', 'type' => 'Payment'])
                ->whereMonth('created_at', '=', $currentDate->month)
                ->whereYear('created_at', '=', $currentDate->year)
                ->sum('amount');

            $data['totals_2'] = DB::table('company_quickpay_payments')
                ->where(['state' => 'Approved', 'type' => 'Payment'])
                ->whereMonth('created_at', '=', $currentDate->month)
                ->whereYear('created_at', '=', $currentDate->year)
                ->sum('amount');

            $data['totals'] = number_format($data['totals'], 2, '.', '') + number_format($data['totals_2'], 2, '.', '');
            $data['videos'] = count($monthlyvideos);
           // $data[$arrKey]['videos_deleted'] = count($monthlyvideos) - count($monthlyActivevideos);
            $data['total_videos'] = count($totalmonthlyvideos);
            //$data[$arrKey]['total_videos_deleted'] = count($totalmonthlyvideos) - count($totalmonthlyactivevideos);
            $data['total_pool_money'] = number_format(($data['totals'] * config('iviggo.speaker_pool')['percentage']) / 100, 2, '.', '');

            if (empty($data['total_videos']) && empty($data['videos'])) {
                $data['pecentage'] = 0;
            } else {
                $data['pecentage'] = number_format(($data['total_pool_money'] / $data['total_videos']), 2, '.', '');
            }

            if (!empty($data['pecentage']) && !empty($data['videos'])) {
                $data['my_commision'] = ($data['pecentage'] * $data['videos']);
            } else {
                $data['my_commision'] = 0;
            }

            $data['pecentage'] = number_format($data['pecentage'], 2, '.', '');
            $data['my_commision'] = number_format($data['my_commision'], 2, '.', '');

           // $startDateTime = $startDateTime->addMonthsNoOverflow();
        }


        $adminRecord = Video::withoutTrashed()->where(['videos.status' => 'approved'])->join('users', 'users.id', '=', 'videos.created_user_id')->orderBy('created_at', 'desc')->get(['created_user_id','videos.deleted_at','video_id','video_title','videos.created_at','users.first_name','users.last_name']);


        foreach ($adminRecord as $rec) {
            $videoCount = Video::withoutTrashed()->where(['videos.status' => 'approved'])->orderBy('created_at', 'desc')->whereMonth('created_at', '=',  $rec->created_at->month)->whereYear('created_at', '=',  $rec->created_at->year)->orderBy('created_at', 'asc')->get(['created_user_id','video_id','video_title','videos.created_at','videos.deleted_at'])->toArray();

            $monthandYear = Carbon::parse($rec->created_at)->englishMonth . ', ' . Carbon::parse($rec->created_at)->year;
            $admindata['main'][$monthandYear]['videoCount'] = count($videoCount);


            $admindata['main'][$monthandYear]['m_total']  = DB::table('quickpay_payments')
            ->where(['state'=>'Approved','type'=>'Payment'])
                ->whereMonth('created_at', '=', $rec->created_at->month)
                ->whereYear('created_at', '=', $rec->created_at->year)
            ->sum('amount');


            $admindata['main'][$monthandYear]['c_total'] = DB::table('company_quickpay_payments')
                ->where(['state'=>'Approved','type'=>'Payment'])
                ->whereMonth('created_at', '=', $rec->created_at->month)
                ->whereYear('created_at', '=', $rec->created_at->year)
                ->sum('amount');

            $admindata['main'][$monthandYear]['totals'] = number_format($admindata['main'][$monthandYear]['m_total'], 2, '.', '') + number_format($admindata['main'][$monthandYear]['c_total'], 2, '.', '');
            $admindata['main'][$monthandYear]['total_pool_money'] = number_format(($admindata['main'][$monthandYear]['totals'] * config('iviggo.speaker_pool')['percentage']) / 100, 2, '.', '');
            $coachVideos= Video::withoutTrashed()->where(['created_user_id' => $rec->created_user_id, 'status' => 'approved'])->whereDate('created_at', '=',  $rec->created_at->toDateString())->orderBy('created_at', 'asc')->get(['id','video_id','video_title','created_user_id','deleted_at'])->toArray();
            $admindata['main'][$monthandYear]['coach'][$rec->created_user_id][] = $rec;

        }


        if($user->hasRole('superadmin')) {
            $records['data'] = $admindata;
            $records['admin'] = true;
        }else{
            $records['data'] = array_reverse($data);
            $records['admin'] = false;
        }


        $totalVideosInSystem = Video::withoutTrashed()->where([ 'status' => 'approved'])->orderBy('created_at', 'asc')->count();
        $totalVideosInSystemByUser = Video::withoutTrashed()->where(['created_user_id' => $user->id, 'status' => 'approved'])->orderBy('created_at', 'asc')->count();
        $commissionDetails['qp']  = DB::table('quickpay_payments')
            ->where(['state'=>'Approved','type'=>'Payment'])
            ->whereMonth('created_at', '=', $currentDate->month)
            ->whereYear('created_at', '=', $currentDate->year)
            ->sum('amount');

        $commissionDetails['cp'] = DB::table('company_quickpay_payments')
            ->where(['state'=>'Approved','type'=>'Payment'])
            ->whereMonth('created_at', '=', $currentDate->month)
            ->whereYear('created_at', '=', $currentDate->year)
            ->sum('amount');

        $commissionDetails['total'] = number_format($commissionDetails['qp'], 2, '.', '') + number_format($commissionDetails['cp'], 2, '.', '');
        $commissionDetails['total_pool_money'] = number_format(($commissionDetails['total'] * config('iviggo.speaker_pool')['percentage']) / 100, 2, '.', '');

        if($totalVideosInSystem >0) {
            $commissionPerVideo = number_format($commissionDetails['total_pool_money'] / $totalVideosInSystem, 2, '.', '');
            $mycommission = number_format($totalVideosInSystemByUser * $commissionPerVideo, 2, '.', '');
        }


        $data['payouts_sum'] = Payouts::where('created_user_id',$user->id)->whereIn('status',['waiting','approved'])->sum('amount');
        $data['payouts'] = Payouts::where('created_user_id',$user->id)->get();

        //$records['ucommission'] = Commissions::where('partner_id',$user->id)->sum('commission') - $data['payouts_sum'];
        if(isset($mycommission)) {
            $records['ucommission'] = round($mycommission, 2);
        }else{
            $records['ucommission'] = 0;
        }
        $data['profile'] = CoachProfileInfo::with('user')->where('created_user_id',$user->id)->first();
  /*      $data['tree'] = CoachProfileInfo::where('created_user_id',$user->id)->first()->getAllChildren();

        $records['twoLevel'] = CoachProfileInfo::where('created_user_id',$user->id)->first()->getTwoLevels();*/
        $records['user'] = $user;
        //return $records;
        return view('bo.pool', $records);
    }


}
/*              $data[$arrKey]['total_clicks'] = 0;
              $data[$arrKey]['my_clicks'] = 0;*/

/*                $data[$arrKey]['my_clicks'] = VideoView::whereIn('video_id', $monthlyvideos)
                    ->whereMonth('created_at', $startDateTime->month)
                    ->whereYear('created_at', $startDateTime->year)->count('id');*/

/*  $data[$arrKey]['total_clicks'] = VideoView::whereMonth('created_at', $startDateTime->month)
      ->whereYear('created_at', $startDateTime->year)
      ->count('id');*/
