<?php

namespace App\Http\Controllers\Bo;

use Auth;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Countries;
use App\User;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Input;
use Spatie\Permission\Traits\HasRoles;
use App\Traits\UploadTrait;
use Illuminate\Database\Eloquent\Builder;
use Carbon\Carbon;





class MembersController extends Controller
{

    protected $user;
    use UploadTrait;
    use HasRoles;

    public function __construct()
    {

    }

    public function index(Request $request)
    {
        $this->user = Auth::user();

        $data['users'] = User::with(['coachInfo','roles'])->where('id', '>', '2')->whereIn('status', ['active','disable'])->orderBy('id','desc')->whereHas('roles', function ($q) {
            $q->where('roles.name', '!=', 'companyuser'); // or whatever constraint you need here
        })->get();

     /*   $employees = User::whereHas('roles', function ($q) {
            $q->where('roles.name', '=', 'admin'); // or whatever constraint you need here
        })->get();*/

        $users = User::with(['coachInfo','roles'])->where('id', '>', '2')->whereIn('status', ['active','disable'])->orderBy('id','desc')->get();
        $data['countries'] = Countries::pluck('country_name','country_code')->toArray();;

        $data['totals']['users'] = $data['users']->count();
        $members = User::role('user')->where('id', '>', '2')->whereIn('status', ['active','disable'])->get();
        $data['totals']['members'] = $members->count();
        $coaches = User::role('coach')->where('id', '>', '2')->whereIn('status', ['active','disable'])->get();
        $data['totals']['coaches'] = $coaches->count();
        $area_managers = User::role('is_am')->where('id', '>', '2')->where(['marketing_terms'=>'yes'])->get();
        $data['totals']['area_managers'] = $area_managers->count();
        $vips = User::role('is_vip')->where('id', '>', '2')->where(['marketing_terms'=>'yes'])->get();
        $data['totals']['vips'] = $vips->count();
        $partners = User::where('id', '>', '2')->where(['marketing_terms'=>'yes'])->get();
        $data['totals']['partners'] = $partners->count();
        $data['totals']['marketing_status'] = $users->countBy(function ($q) {
            return $q->marketing_status;
        });
        $data['totals']['website_status'] = $users->countBy(function ($q) {
            return $q->status;
        });

        //return $data['totals'];
        //$video_languages = array_unique(Arr::pluck($filtersOptions,'language'));

        //$test['members'] = array_unique(Arr::pluck($filtersOptions,'language'));
       // return $data;
        return view('bo.members',$data);
    }




}
