<?php

namespace App\Http\Controllers\Bo;

use App\CoachIntro;
use App\CoachProfileInfo;
use Auth;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Countries;
use App\User;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Input;
use Spatie\Permission\Traits\HasRoles;
use App\Traits\UploadTrait;
use Illuminate\Database\Eloquent\Builder;
use Carbon\Carbon;





class DashboardController extends Controller
{

    protected $user;
    use UploadTrait;
    use HasRoles;

    public function __construct()
    {

    }

    public function index(Request $request)
    {
        $data = $request->all();
        $this->user = Auth::user();
        //$data["user"] = User::with(['coachInfo'])->get();

        $countries = Countries::pluck('country_name','country_code')->toArray();;
        $data['statuses'] = [null=>'All','2'=>'Pending','1'=>'Approved'];
        $data['duration'] = [null=>'All','2'=>'One Month Old','1'=>'Recent'];






        $users = User::role('coach');

        if($this->user->hasAllRoles(['is_am','coach'])) {
            $coachTree = new CoachProfileInfo();
            $childUsers = $coachTree->allTree(CoachProfileInfo::where('created_user_id',$this->user->id)->first());
            $users = $users->whereIn('id',$childUsers);
        }



        $filtersOptions  =  $users->with('coachInfo')->whereIn('status', ['active','inactive'])->get();



        $coach_countries = array_unique(Arr::pluck($filtersOptions,'coachinfo.country'));

        $data['countries'] = [];
        foreach($coach_countries as $key)
        {
            if(array_key_exists($key, $countries))
            {
                $data['countries'][$key] = $countries[$key];
            }
        }

        if(count($data['countries'])==0) {
            $data['countries'] = $countries;
        }

        if ($request->has('country') && !empty($request->country)) {
            $data['country'] = $request->country;
            $countryFilter = function ( $q) use($request){
                $q->where('country', $request->country);
            };
            $users =$users->with(['coachInfo'=>$countryFilter])->whereHas('coachInfo',$countryFilter);

        } else {
            $users = $users->with(['coachInfo']);
        }

        if ($request->has('status') && !empty($request->status)) {
            $data['status'] = $request->status;
            $users =$users->where('status',(($request->status=='1') ? 'active':'inactive'));

        }

        if ($request->has('state') && !empty($request->state)) {
            $data['state'] = $request->state;
            if($request->state=='2') {
                $users =$users->where('created_at','>', Carbon::now()->subDays(30));
            }
            if($request->state=='1') {
                $users =$users->where('created_at',Carbon::today());
            }


        }


        $users = $users->whereIn('status',['active','inactive'])->orderBy('first_name', 'asc')->paginate(128);
        $data["users"] = $users;
        //return $data;
        return view('bo.coaches', $data);
    }

    public function profile($id) {
        if(!$id || !is_numeric($id))
        {
            return redirect()->route( 'bo.dashboard');
        }

        $data["user"] = User::with(['coachInfo','coachIntro'])->where('id', $id)->get(['id', 'first_name','last_name', 'email'])->first();
        return view('bo.pages.profile', $data);
    }


}
