<?php

namespace App\Http\Controllers\Bo;


use App\Commissions;
use App\CompanyQuickpayPayments;
use App\Exports\CompanyPayoutsExports;
use App\Http\Controllers\Controller;
use App\QuickpayPayments;
use App\QuickpaySubscriptions;
use App\SpeakersPool;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Facades\Excel;

use Carbon\Carbon;
use Illuminate\Support\Facades\DB;


use Illuminate\Support\Facades\Auth;
use App\VideoView;
use App\Video;

class CompanyPayoutsController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */

    public function __construct()
    {
        // $this->middleware('auth');
    }

    public function index()
    {
        $currentDate = Carbon::now()->addMonth();
        $currentDateString = $currentDate->englishMonth . ', ' . $currentDate->year;
        $oldest = CompanyQuickpayPayments::where(['state'=>'Approved','type'=>'Payment'])->orderBy('created_at', 'asc')->first();

        $data = [];
        if (isset($oldest->id)) {

            $startDateTime =Carbon::parse($oldest->created_at);

            while ($startDateTime->englishMonth.', ' .$startDateTime->year!=$currentDateString) {

                $arrKey = $startDateTime->englishMonth . ', ' . $startDateTime->year;

                $totals = 0;
                $data[$arrKey]['month'] =$startDateTime->month;
                $data[$arrKey]['year'] =$startDateTime->year;
                $data[$arrKey]['totals'] = DB::table('company_quickpay_payments')
                    ->where(['state'=>'Approved','type'=>'Payment'])
                    ->whereMonth('created_at', $startDateTime->month)
                    ->whereYear('created_at', $startDateTime->year)
                    ->sum('amount');
                $data[$arrKey]['totals'] = number_format($data[$arrKey]['totals'], 2, '.', '');
                $data[$arrKey]['payouts'] = DB::table('commissions')
                    ->whereMonth('created_at', $startDateTime->month)
                    ->whereYear('created_at', $startDateTime->year)
                    ->where('type', 'member')
                    ->sum('commission');

                //$data[$arrKey]['commision_amount'] = number_format($data[$arrKey]['commision_amount'], 2, '.', '');
                $data[$arrKey]['payouts'] = number_format($data[$arrKey]['payouts'], 2, '.', '');
                $data[$arrKey]['teo'] = number_format(($data[$arrKey]['totals'] * config('iviggo.teo_payout')['percentage']) / 100, 2, '.', '');
                $data[$arrKey]['peter'] = number_format(($data[$arrKey]['totals'] * config('iviggo.peter_payout')['percentage']) / 100, 2, '.', '');
                $data[$arrKey]['simon'] = number_format(($data[$arrKey]['totals'] * config('iviggo.simon_payout')['percentage']) / 100, 2, '.', '');
                $data[$arrKey]['iviggo'] = number_format($data[$arrKey]['totals'] - $data[$arrKey]['payouts'] - $data[$arrKey]['teo'] - $data[$arrKey]['simon'] - $data[$arrKey]['peter'], 2, '.', '');


                $startDateTime = $startDateTime->addMonth();
            }

        }
        //return $data;

        $records['data'] = array_reverse($data);


        return view('bo.pages.company_payouts', $records);
    }

    public function export($month,$year){

        if(!empty($month) && !empty($year) && $month<=12) {


            return Excel::download(new CompanyPayoutsExports($month, $year), $month . '_' . $year . '.xlsx');

        }

    }

    public function pool()
    {
        $user = Auth::user();

        $currentDate = Carbon::now()->addMonth();
        $currentDateString = $currentDate->englishMonth . ', ' . $currentDate->year;

        $oldestRecord = Video::withTrashed()->where(['created_user_id' => $user->id, 'status' => 'approved'])->orderBy('created_at', 'asc')->first();
        $data = [];

        //return $oldestRecord;

        if (isset($oldestRecord->id)) {

            $startDateTime =Carbon::parse($oldestRecord->created_at);

            while ($startDateTime->englishMonth.', ' .$startDateTime->year!=$currentDateString) {

                $arrKey = $startDateTime->englishMonth . ', ' . $startDateTime->year;

                $monthlyvideos = Video::withTrashed()->where(['created_user_id' => $user->id, 'status' => 'approved'])->orderBy('created_at', 'asc')->whereDate('created_at','<=', $startDateTime->endOfMonth()->toDateString())->pluck('id');
                $monthlyActivevideos = Video::where(['created_user_id' => $user->id, 'status' => 'approved'])->orderBy('created_at', 'asc')->whereDate('created_at','<=', $startDateTime->endOfMonth()->toDateString())->pluck('id');

                $monthlyvideos  = $monthlyvideos->unique();
                $monthlyActivevideos  = $monthlyActivevideos->unique();
                $data[$arrKey]['total_clicks'] = 0;
                $data[$arrKey]['my_clicks'] = 0;
                $data[$arrKey]['videos'] = 0;

                $commision_amount = DB::table('speakers_pool')
                    ->whereMonth('pool_date', $startDateTime->month)
                    ->whereYear('pool_date', $startDateTime->year)
                    ->sum('amount');


                $data[$arrKey]['videos'] = count($monthlyActivevideos);
                $data[$arrKey]['videos_deleted'] = count($monthlyvideos)-count($monthlyActivevideos);

                $data[$arrKey]['my_clicks'] = VideoView::whereIn('video_id', $monthlyvideos)
                    ->whereMonth('created_at', $startDateTime->month)
                    ->whereYear('created_at', $startDateTime->year)->count('id');

                $data[$arrKey]['25_pool'] = $commision_amount;

                $data[$arrKey]['total_clicks'] = VideoView::whereMonth('created_at', $startDateTime->month)
                    ->whereYear('created_at', $startDateTime->year)
                    ->count('id');



                if (empty($data[$arrKey]['total_clicks']) && empty($data[$arrKey]['my_clicks'])) {
                    $data[$arrKey]['pecentage'] = 0;
                } else {
                    $data[$arrKey]['pecentage'] = number_format(($data[$arrKey]['my_clicks'] / $data[$arrKey]['total_clicks']) * 100, 2, '.', '');
                }

                if(!empty($data[$arrKey]['pecentage']) && !empty($commision_amount)) {
                    $data[$arrKey]['my_commision'] = ($data[$arrKey]['pecentage'] * $commision_amount)/100;
                } else {
                    $data[$arrKey]['my_commision'] = 0;
                }
                $data[$arrKey]['pecentage'] = number_format($data[$arrKey]['pecentage'],2,'.','');
                $data[$arrKey]['my_commision'] = number_format($data[$arrKey]['my_commision'],2,'.','');

                $startDateTime = $startDateTime->addMonthsNoOverflow();

            }

        }

        $records['data'] = array_reverse($data);


        return view('bo.pool', $records);
    }


}
