<?php

namespace App\Http\Controllers\Bo;

use App\CoachIntro;
use App\Mail\CoachUpgrade;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use App\User;
use Auth;
use DB;
use Carbon\Carbon;
use App\Mail\CoachActive;
use App\Mail\CoachRejected;
use App\Mail\VideoActive;
use App\Mail\VideoRejected;
use App\Mail\IntroVideoActive;
use App\Mail\IntroVideoRejected;
use App\Video;
use Vimeo;

use App\QuestionReplies;
use App\Question;

class AjaxController extends Controller
{
    protected $user;

    public function __construct(Request $request)
    {
        $this->middleware(['ajax']);
    }

    public function coaches(Request $request)
    {
        $this->validate($request,[
            'id' => 'required|integer',
            'type' => 'required|alpha',
        ]);

        $id = $request->input("id");
        $type = $request->input("type");
        $this->user = Auth::user();
        $code = 200;
        $response = [];

        if(!is_numeric($id) || $id == 0 || strpos($id, "."))
        {
            return response()->json(["message" => "Bad request"], 422);
        }

        if( !in_array($type, ["remove",'active', 'disable']) )
        {
            return response()->json(["message" => "Bad request"], 422);
        }


        $coach = User::where('id', '=', $id)->get(['id', 'first_name','last_name', 'email'])->first();

        if(isset($coach->id)) {
/*
            if($type=='enable')
            {
                $coach->status = 'active';
                $coach->save();

                //Mail::to($coach->email)->send(new CoachActive($coach));

                $response["message"] = "Account is enabled.";
            }*/

            if($type=='active')
            {
                $coach->status = 'active';
                $coach->save();

                Mail::to($coach->email)->send(new CoachActive($coach));

                $response["message"] = "Account is approved.";
            }

            if($type=='disable')
            {
                $coach = User::where('id', '=', $id)->get(['id', 'first_name','last_name', 'email'])->first();
                $coach->status = 'disable';
                $coach->save();

                Mail::to($coach->email)->send(new CoachRejected($coach));

                $response["message"] = "Account is rejected.";
            }
            if($coach->status=='inactive') {
                $response['html'] = '<button data-toggle="tooltip" data-placement="right" title="Reject Account" class="statusdeactive co_act" data-id="'.$coach->id.'" data-type="disable"><i class="fa fa-times " aria-hidden="true"></i></button>';

                $response['html'] .= ' <button data-toggle="tooltip" data-placement="right" title="Approve Account"  class="statusactive co_act"  data-type="active"  data-id="'.$coach->id.'"><i class="fa fa-check " aria-hidden="true"></i></button>';

            }

            if($coach->status=='active') {

                $response['html'] = '<button data-toggle="tooltip" data-placement="right" title="Delete Account" class="statusdeactive co_act" data-id="'.$coach->id.'" data-type="remove"><i class="fa fa-trash " aria-hidden="true"></i></button>';
            }

            /*if($coach->status=='inactive') {
                $response['html'] = '<button data-toggle="tooltip" data-placement="right" title="Reject Account" class="statusdeactive co_act" data-id="'.$coach->id.'" data-type="disable"><i class="fa fa-times " aria-hidden="true"></i></button>';

                $response['html'] .= ' <button data-toggle="tooltip" data-placement="right" title="Approve Account"  class="statusactive co_act"  data-type="active"  data-id="'.$coach->id.'"><i class="fa fa-check " aria-hidden="true"></i></button>';

            }elseif($coach->status=='disable') {
                $response['html'] = '<button data-toggle="tooltip" data-placement="right" title="Delete Account" class="statusdeactive co_act" data-id="'.$coach->id.'" data-type="remove"><i class="fa fa-trash " aria-hidden="true"></i></button>';
                $response['html'] .= ' <button data-toggle="tooltip" data-placement="right" title="Enable Account"  class="statusactive co_act"  data-type="enable"  data-id="'.$coach->id.'"><i class="fa fa-check " aria-hidden="true"></i></button>';
            }elseif($coach->status=='active') {
                $response['html'] = '<button data-toggle="tooltip" data-placement="right" title="Delete Account" class="statusdeactive co_act" data-id="'.$coach->id.'" data-type="remove"><i class="fa fa-trash " aria-hidden="true"></i></button>';
                $response['html'] .= ' <button data-toggle="tooltip" data-placement="right" title="Disable Account"  class="statusdeactive co_act"  data-type="disable"  data-id="'.$coach->id.'"><i class="fa fa-times " aria-hidden="true"></i></button>';
            }*/

            if($type=='remove')
            {
                $coach = User::where('id', '=', $id)->delete();

                $response["message"] = "Account is deleted.";
            }





        } else {
            $response["message"] = "User not found";
            $code = 422;
        }


        return response()->json($response, $code);

    }

    public function video(Request $request)
    {
        $this->validate($request,[
            'id' => 'required|integer',
            'type' => 'required|alpha',
        ]);

        $id = $request->input("id");
        $type = $request->input("type");
        $this->user = Auth::user();
        $code = 200;
        $response = [];

        if(!is_numeric($id) || $id == 0 || strpos($id, "."))
        {
            return response()->json(["message" => "Bad request"], 422);
        }

        if( !in_array($type, ["remove",'approved']) )
        {
            return response()->json(["message" => "Bad request"], 422);
        }


        $video = Video::with(['user'])->where('id', $id)->get()->first();
        if(!isset($video->id))
        {
            $response["message"] = "Video not found";
            $code = 404;
            return response()->json($response, $code);
        }

        if($type=='approved')
        {

            $video = Video::where('id', $id)->get()->first();

            $video->status = 'approved';
            $video->save();
            $video = Video::with(['user'])->where('id', $id)->get()->first();

            Mail::to($video->user->email)->send(new VideoActive($video,$type='video'));


            $questions = QuestionReplies::where('video_id',$video->id);



            $response["message"] = "Video is approved.";
        }
        elseif($type=='remove')
        {

            $this->validate($request,[
                'message' => 'required'
            ]);


            $response = Vimeo::request('/videos', ['video_id'=>$video->video_id],'Delete');
            Mail::to($video->user->email)->send(new VideoRejected($video,$request->input("message")));
            Video::where('id', $id)->delete();


            $response["message"] = "Video is rejected.";
        }
        else
        {
            $response["message"] = "Video not found";
            $code = 422;
        }

        return response()->json($response, $code);

    }

    public function intros(Request $request)
    {
        $this->validate($request,[
            'id' => 'required|integer',
            'type' => 'required|alpha',
        ]);

        $id = $request->input("id");
        $type = $request->input("type");
        $this->user = Auth::user();
        $code = 200;
        $response = [];

        if(!is_numeric($id) || $id == 0 || strpos($id, "."))
        {
            return response()->json(["message" => "Bad request"], 422);
        }

        if( !in_array($type, ["remove",'approved','reject']) )
        {
            return response()->json(["message" => "Bad request"], 422);
        }

        $video = CoachIntro::with(['user'])->where('id', $id)->get()->first();


        if(!isset($video->id))
        {
            $response["message"] = "Video not found";
            $code = 404;
            return response()->json($response, $code);
        }

        if($type=='approved')
        {

           // $video = CoachIntro::where('id', $id)->get()->first();
            $video->status = 'active';
            $video->save();
            $video = CoachIntro::with(['user'])->where('id', $id)->get()->first();

            Mail::to($video->user->email)->send(new IntroVideoActive($video,$type='intro'));

            $response["message"] = "Introductory Video is approved.";
        }

        if($type=='remove')
        {

            $this->validate($request,[
                'message' => 'required'
            ]);


            $response = Vimeo::request('/videos', ['video_id'=>$video->video_id],'Delete');
            CoachIntro::where('id', $id)->delete();
            //Mail::to($video->user->email)->send(new IntroVideoRejected($video,$request->input("message"),$type='intro'));

            $response["message"] = "Introductory Video is Deleted.";
        }
        if($type=='reject')
        {

            $this->validate($request,[
                'message' => 'required'
            ]);
           // return $request->input("message");
            //return $video;
            //$video = CoachIntro::with(['user'])->where('id', $id)->get()->first();
            $response = Vimeo::request('/videos', ['video_id'=>$video->video_id],'Delete');
            Mail::to($video->user->email)->send(new IntroVideoRejected($video,$request->input("message")));
            CoachIntro::where('id', $id)->delete();


            $response["message"] = "Introductory Video is Rejected.";
        }





        return response()->json($response, $code);

    }

    public function update(Request $request)
    {
        $this->validate($request, [
            'id' => 'required|integer',
            'type' => 'required|alpha',
        ]);

        $id = $request->input("id");
        $type = $request->input("type");
        $this->user = Auth::user();
        $code = 200;
        $response = [];


        if (!is_numeric($id) || $id == 0 || strpos($id, ".")) {
            return response()->json(["message" => "Bad request"], 422);
        }

        if (!in_array($type, ['delete', 'upgrade'])) {
            return response()->json(["message" => "Bad request"], 422);
        }

        if ($type == 'delete') {
            $userInfo = User::find($id);
            if (isset($userInfo->id)) {
                $userInfo->delete();
                $response["message"] = "User is deleted.";
            }
        } else {
            $userInfo = User::role('user')->find($id);
            if (isset($userInfo->id)) {
                $userInfo->assignRole('coach');
                $userInfo->removeRole('user');
                $response["message"] = "User is upgraded to Coach.";

                Mail::to($userInfo->email)->send(new CoachUpgrade($userInfo));


            }
        }

        return response()->json($response, $code);

    }


    public function status(Request $request)
    {
        $this->validate($request, [
            'id' => 'required|integer',
            'type' => 'required|alpha',
        ]);

        $id = $request->input("id");
        $type = $request->input("type");
        $this->user = Auth::user();
        $code = 200;
        $response = [];


        if (!is_numeric($id) || $id == 0 || strpos($id, ".")) {
            return response()->json(["message" => "Bad request"], 422);
        }

        if (!in_array($type, ['m', 'w'])) {
            return response()->json(["message" => "Bad request"], 422);
        }
        $userInfo = User::find($id);
        if ($type == 'w') {

            if (isset($userInfo->id)) {
                if($userInfo->status=='disable') {
                    $userInfo->status = 'active';
                    $response["message"] = "Enable";
                } else {
                    $userInfo->status = 'disable';
                    $response["message"] = "Disable";
                }
                $userInfo->save();
            }
        } else {
            if (isset($userInfo->id)) {
                if($userInfo->marketing_status=='inactive') {
                    $userInfo->marketing_status = 'active';
                    $response["message"] = "active";
                } else {
                    $userInfo->marketing_status = 'inactive';
                    $userInfo->marketing_inactive = Carbon::now()->toDateTimeString();
                    $response["message"] = "inactive";
                }
                $userInfo->save();
            }
        }

        return response()->json($response, $code);

    }



}
