<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\VerifiesEmails;
use App\User;
use Carbon\Carbon;


class VerificationController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Email Verification Controller
    |--------------------------------------------------------------------------
    |
    | This controller is responsible for handling email verification for any
    | user that recently registered with the application. Emails may also
    | be re-sent if the user didn't receive the original email message.
    |
    */

    use VerifiesEmails;

    /**
     * Where to redirect users after verification.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('signed')->only('verify');
        $this->middleware('throttle:6,1')->only('verify', 'resend');
    }

    public function verifyEmail($email,$secret){
        $email = base64_decode($email); //decode email address
        $secret = base64_decode($secret); // decode verification_code


        $user = User::where('email',$email)->where('verification_code',$secret)->first();


        if($user){// if user exists in storage

            $user->email_verified_at = Carbon::now();
            $user->verification_code = NULL;
            $user->status = 'active';
            $user->save();
            //redirect to to login with email_verified flag set to false
            return redirect('login')->with('status', 'Email successfully verfied. You can login now!');

        }else{// user does not exist in storage
            return redirect("/login");
        }
    }
}
