<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Favorite extends Model
{
    protected $table = 'favorites';

    protected $fillable = [
        'video_id', 'created_user_id', 'updated_user_id'
    ];

    public function user()
    {
        return $this->belongsTo('App\User','created_user_id');
    }

    public function videos()
    {
        return $this->belongsToMany(Video::class, 'videos','id');
    }
}


