<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        //
        Commands\renewSubscription::class,
        Commands\renewNotifications::class,
        Commands\renewCompanyNotifications::class,
        Commands\payoutCheck::class,
        Commands\videoCheck::class,
        Commands\updateVat::class,
        Commands\DatabaseBackUp::class,
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        // $schedule->command('inspire')
        //          ->hourly();
        /*$schedule->command('renew:subscription')
            ->dailyAt('01:00');
        $schedule->command('renew:subscription')
            ->dailyAt('01:00');*/

        $schedule->command('renew:notifications')
        ->daily();
        $schedule->command('renew:companynotifications')
            ->daily();
        $schedule->command('renew:subscription')
            ->dailyAt('01:00');
        $schedule->command('video:update')
            ->everyFiveMinutes();
        $schedule->command('payout:check')
            ->everyFiveMinutes();
       // $schedule->command('vat:update')->monthly();

        $schedule->command('views:payout')->monthlyOn(1, '09:00');
        $schedule->command('database:backup')->hourly();
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
