<?php

namespace App\Console\Commands;

use App\Jobs\RenewNotification;
use App\Mail\CoachSignup;
use App\Mail\RenewEmail;
use App\UserPackage;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Mail;
use Spatie\Permission\Traits\HasRoles;

class renewNotifications extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    use HasRoles;
    protected $signature = 'renew:notifications';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Send renew notifications 1,3,7 days';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        //
        $userPackages = UserPackage::with(['user'=> function ($q) {
            $q->withTrashed();
        }, 'plan'])->where(['status'=>'active','cancels_at'=>NULL, 'canceled_at'=>NULL, 'recurring'=>'inactive'])->whereDate('ends_at', '=', Carbon::now()->addDays(7))->get();


        if($userPackages->count() > 0) {

            foreach($userPackages as $item) {
                if(is_null($item->user->deleted_at) && $item->user->hasRole('user')) {
                    $details = ['record' => $item, 'days'=>7, 'url'=>route('user.payments'),'email'=>$item->user->email];
                    Mail::to($item->user->email)->send(new RenewEmail($details));
                }
            }
        }
        $userPackages = UserPackage::with(['user'=> function ($q) {
            $q->withTrashed();
        }, 'plan'])->where(['status'=>'active','cancels_at'=>NULL, 'canceled_at'=>NULL, 'recurring'=>'inactive'])->whereDate('ends_at', '=', Carbon::now()->addDays(3))->get();
        if($userPackages->count() > 0) {

            foreach($userPackages as $item) {
                if(is_null($item->user->deleted_at) && $item->user->hasRole('user')) {
                    $details = ['record' => $item, 'days'=>3, 'url'=>route('user.payments'),'email'=>$item->user->email];
                    Mail::to($item->user->email)->send(new RenewEmail($details));
                }

            }
        }

        $userPackages = UserPackage::with(['user'=> function ($q) {
            $q->withTrashed();
        }, 'plan'])->where(['status'=>'active','cancels_at'=>NULL, 'canceled_at'=>NULL, 'recurring'=>'inactive'])->whereDate('ends_at', '=', Carbon::now()->addDays(1))->get();
        if($userPackages->count() > 0) {

            foreach($userPackages as $item) {
                if(is_null($item->user->deleted_at) && $item->user->hasRole('user')) {
                    $details = ['record' => $item, 'days' => 1, 'url' => route('user.payments'), 'email' => $item->user->email];
                    Mail::to($item->user->email)->send(new RenewEmail($details));
                }

            }
        }
    }
}
