<?php

namespace App\Console\Commands;

use App\Jobs\RenewNotification;
use App\Mail\CoachSignup;
use App\Mail\RenewCompanyEmail;
use App\User;
use App\UserCompanies;
use App\UserPackage;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Spatie\Permission\Traits\HasRoles;

class renewCompanyNotifications extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    use HasRoles;
    protected $signature = 'renew:companynotifications';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Send company renew notifications 1,3,7 days';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        //
        $userCompanies = UserCompanies::with(['user'=> function ($q) {
            $q->withTrashed();
        }, 'plan'])->where(['status'=>'active','cancels_at'=>NULL, 'canceled_at'=>NULL])->whereDate('ends_at', '=', Carbon::now()->addDays(7))->get();

        $adminEmails = User::role('superadmin')->pluck('email');

        if($userCompanies->count() > 0) {

            foreach($userCompanies as $item) {
                if(is_null($item->user->deleted_at)) {
                    $details = ['record' => $item, 'days' => 1, 'url' => route('company.updatetrans',['trans_id'=>$item->company_id,'renew'=>1]), 'email' => $item->user->email];
                    Mail::to($item->user->email)->send(new RenewCompanyEmail($details));
                    Mail::to($item->plan->owner_email)->send(new RenewCompanyEmail($details));
                    Mail::to($item->plan->company_email)->send(new RenewCompanyEmail($details));
                    Mail::to($adminEmails)->send(new RenewCompanyEmail($details));
                }

            }
        }
        $userCompanies = UserCompanies::with(['user'=> function ($q) {
            $q->withTrashed();
        }, 'plan'])->where(['status'=>'active','cancels_at'=>NULL, 'canceled_at'=>NULL])->whereDate('ends_at', '=', Carbon::now()->addDays(3))->get();
        if($userCompanies->count() > 0) {

            foreach($userCompanies as $item) {
                if(is_null($item->user->deleted_at)) {
                    $details = ['record' => $item, 'days' => 1, 'url' => route('company.updatetrans',['trans_id'=>$item->company_id,'renew'=>1]), 'email' => $item->user->email];
                    Mail::to($item->user->email)->send(new RenewCompanyEmail($details));
                    Mail::to($item->plan->owner_email)->send(new RenewCompanyEmail($details));
                    Mail::to($item->plan->company_email)->send(new RenewCompanyEmail($details));
                    Mail::to($adminEmails)->send(new RenewCompanyEmail($details));
                }

            }
        }

        $userCompanies = UserCompanies::with(['user'=> function ($q) {
            $q->withTrashed();
        }, 'plan'])->where(['status'=>'active','cancels_at'=>NULL, 'canceled_at'=>NULL])->whereDate('ends_at', '=', Carbon::now()->addDays(1))->get();
        if($userCompanies->count() > 0) {

            foreach($userCompanies as $item) {
                if(is_null($item->user->deleted_at)) {
                    $details = ['record' => $item, 'days' => 1, 'url' => route('company.updatetrans',['trans_id'=>$item->company_id,'renew'=>1]), 'email' => $item->user->email];
                    Mail::to($item->user->email)->send(new RenewCompanyEmail($details));
                    Mail::to($item->plan->owner_email)->send(new RenewCompanyEmail($details));
                    Mail::to($item->plan->company_email)->send(new RenewCompanyEmail($details));
                    Mail::to($adminEmails)->send(new RenewCompanyEmail($details));
                }

            }
        }
    }
}
