<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class CompanyQuickpaySubscriptions extends Model
{
    protected $table = 'company_quickpay_subscriptions';

    protected $fillable = [
        'subscription_id','operations', 'order_id', 'metadata', 'link', 'agreement_id', 'amount', 'payment_methods', 'accepted','company_id', 'state', 'created_user_id', 'vat'
    ];



    public function user()
    {
        return $this->belongsTo('App\User','created_user_id');
    }


    public function company()
    {
        return $this->belongsTo('App\UserCompanies','company_id');
    }

    public function quickpayRecurring() {
        return $this->hasMany('App\QuickpayRecurring','subscription_id','subscription_id');
    }

    public function companyQuickpayPayments() {
        return $this->hasMany('App\CompanyQuickpayPayments','subscription_id','subscription_id');
    }

    public function getCreatedAtAttribute($value)
    {
        $timezone = optional(auth()->user())->timezone ?? config('app.timezone');
        return Carbon::parse($value)->timezone($timezone);
    }

    public function getUpdatedAtAttribute($value)
    {
        $timezone = optional(auth()->user())->timezone ?? config('app.timezone');
        return Carbon::parse($value)->timezone($timezone);
    }
}


