<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class CoachSubscription extends Model
{
    protected $table = 'subscriptions';

    protected $fillable = [
        'coach_id', 'created_user_id', 'updated_user_id'
    ];

    public function user()
    {
        return $this->belongsTo('App\User','created_user_id');
    }

    public function coach()
    {
        return $this->belongsTo('App\User', 'coach_id');
    }
}


