<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Log;
use Spatie\Permission\Traits\HasRoles;
use App\UserPackage;
use Auth;

class CoachProfileInfo extends Model
{
    protected $table = 'coach_profile';
    use SoftDeletes;
    use HasRoles;
    protected $fillable = [
        'referral_invite_code', 'country', 'invite_code', 'coach_url','photo', 'slogan', 'introduction', 'expertise', 'website', 'company', 'created_user_id', 'updated_user_id', 'mobile'
    ];

    public function user()
    {
        return $this->belongsTo('App\User', 'created_user_id', 'id');
    }

    public function subscribers()
    {
        return $this->belongsTo('App\CoachSubscription', 'coach_id');
    }

    public function children()
    {
        return $this->hasMany('App\CoachProfileInfo', 'referral_invite_code', 'invite_code');
    }


    public function parent()
    {
        return $this->hasOne('App\CoachProfileInfo', 'referral_invite_code', 'invite_code');
    }

    public function getAllChildren()
    {
        $collection = array();
        $members = CoachProfileInfo::withTrashed()->select('id','created_user_id','invite_code','referral_invite_code')
            ->where('referral_invite_code', $this->invite_code)->with(['user' => function ($q) {
                $q->withTrashed()->select('id','marketing_status','marketing_terms','deleted_at');
            }])->get();
        $i = 1;


        while (count($members)>0) {
            //add category to collection
            $inviteCodes = [];

            foreach ($members as $item) {

                if($item->user->hasRole('user')) {

                    $memberShip = UserPackage::where(['created_user_id'=>$item->user->id])->whereIn('status',['active','expired'])->latest('id')->first();
                    Log::info('** Membership **');
                    Log::info(json_encode($item->user));
                    if(isset($memberShip->id)) {
                        $memberShipType = $memberShip->package_id;

                        if($memberShipType>2) {
                            $collection['level_' . $i]['free'][] = $item;
                        } else {
                            if ($item->user->marketing_status == 'active' && $item->user->marketing_terms == 'yes') {

                                $collection['level_' . $i]['active'][] = $item;

                            } else {

                                $collection['level_' . $i]['inactive'][] = $item;
                            }
                        }
                    } else {
                        if ($item->user->marketing_status == 'active' && $item->user->marketing_terms == 'yes') {

                            $collection['level_' . $i]['active'][] = $item;

                        } else {

                            $collection['level_' . $i]['inactive'][] = $item;
                        }
                    }

                } else {
                    if ($item->user->marketing_status == 'active' && $item->user->marketing_terms == 'yes') {

                        $collection['level_' . $i]['active'][] = $item;

                    } else {

                        $collection['level_' . $i]['inactive'][] = $item;
                    }
                }


                $inviteCodes[] = $item->invite_code;

            }

            $members = CoachProfileInfo::whereIn('referral_invite_code', $inviteCodes)->select('id','created_user_id','invite_code','referral_invite_code')->withTrashed()->with(['user' => function ($q) {
                $q->withTrashed()->select('id','marketing_status','marketing_terms','deleted_at');
            }])->get();



            $i++;
        }

        return $collection;
    }

    public function getTwoLevels()
    {
        $collection = array();
        $members = CoachProfileInfo::withTrashed()
            ->where('referral_invite_code', $this->invite_code)->with(['user' => function ($q) {
                $q->withTrashed();
            }])->get();
        return $members;
        $i = 1;
        if ($members != null) {
            foreach ($members as $item) {




                $submembers = CoachProfileInfo::where('referral_invite_code', $item->invite_code)->withTrashed()->with(['user' => function ($q) {
                    $q->withTrashed();
                }])->get();
                $item->childs = $submembers;

                $collection[$i] = $item;

                $i++;
            }
        }

        return $collection;
    }

    public function getAllParentsNew()
    {
        $adminUsers = User::role('superadmin')->with('coachInfo')->get();
        $adminUsersCode = Arr::pluck($adminUsers, 'coachInfo.invite_code');

        $collection = array();
        $i = CoachProfileInfo::where('invite_code', $this->referral_invite_code)->withTrashed()->with(['user' => function ($q) {
            $q->withTrashed();
        }])->first();
        $z = 0;

        while ($i != NULL) {
            Log::info('ROLE IS: '.$i->user->getRoleNames());
            if ($i->user->marketing_status == 'active' && $i->user->marketing_terms == 'yes') {
                if ($i->user->hasRole('user')) {
                    $collection['member_users'][$z] = $i;
                }
              /*  if ($i->user->hasRole('is_mp')) {
                    $collection['partners'][$z] = $i;
                }*/
                if ($i->user->hasRole('is_am')) {
                    $collection['am'][$z] = $i;
                }
                if ($i->user->hasRole('coach')) {
                   /* if(in_array($i->referral_invite_code, $adminUsersCode) && $i->invite_code == $this->referral_invite_code) {
                        $collection['superadmin'][$z] = $i;
                    }else{*/
                        $collection['coach'][$z] = $i;
                 /*   }*/
                }
            }
            if(isset($i->referral_invite_code)) {
                $i = CoachProfileInfo::withTrashed()->where('invite_code', $i->referral_invite_code)->with(['user' => function ($q) {
                    $q->withTrashed();
                }])->first();
            }else{
                return $collection;
            }
            $z++;
       }
        return $collection;
    }

    public function getAllParents()
    {

        $collection = array();
        if($this->referral_invite_code == ''){
            return $collection;
        }else {
            $i = CoachProfileInfo::where('invite_code', $this->referral_invite_code)->withTrashed()->with(['user' => function ($q) {
                $q->withTrashed();

            }])->first();

            $adminUsers = User::role('superadmin')->with('coachInfo')->get();
            $adminUsersCode = Arr::pluck($adminUsers, 'coachInfo.invite_code');

            $am = User::role('is_am')->with('coachInfo')->get();
            $amCode = Arr::pluck($am, 'coachInfo.invite_code');

            $z = 0;
            Log::info('User is: '.json_encode($i->user));

            if ($i->user->hasRole('user')) {
                if ($i->user->marketing_status == 'active' && $i->user->marketing_terms == 'yes') {
                    $collection['member_users'][$z] = $i;
                }
                return $collection;
            }

            Log::info(json_encode($i->user->getRoleNames()));

            while ($i != NULL) {
                if ($i->user->marketing_status == 'active' && $i->user->marketing_terms == 'yes') {
                    if ($i->user->hasRole('is_vip')) {
                        $collection['vip'][$z] = $i;
                    }
                    if ($i->user->hasRole('is_am')) {
                        if (in_array($this->referral_invite_code, $amCode)) {
                            $collection['onlyam'][$z] = $i;
                        } else {
                            $collection['am'][$z] = $i;
                        }
                    }
                }
                $i = CoachProfileInfo::withTrashed()->where('invite_code', $i->referral_invite_code)->with(['user' => function ($q) {
                    $q->withTrashed();
                }])->first();
                $z++;
            }
        }
        return $collection;
    }


    public function getAllCompanyParents()
    {
        $adminUsers = User::role('superadmin')->with('coachInfo')->get();
        $adminUsersCode = Arr::pluck($adminUsers, 'coachInfo.invite_code');

        $am = User::role('is_am')->with('coachInfo')->get();
        $amCode = Arr::pluck($am, 'coachInfo.invite_code');

        Log::info(json_encode($this));


        $collection = array();
        if($this->referral_invite_code == ''){
            return $collection;
        }else {
            $i = CoachProfileInfo::where('invite_code', $this->referral_invite_code)->withTrashed()->with(['user' => function ($q) {
                $q->withTrashed();
            }])->first();
         /*   if ($this->user->marketing_status == 'active' && $this->user->marketing_terms == 'yes') {*/
                if (in_array($this->referral_invite_code, $adminUsersCode)) {
                    $collection['superadmin'][0] = $this;
                } else {
                    $collection['coach'][0] = $this;
                }
            /*}*/
            if ($i->user->marketing_status == 'active' && $i->user->marketing_terms == 'yes') {
                if (in_array($this->referral_invite_code, $adminUsersCode)) {
                    return $collection;
                } else {
                    $collection['am'][1] = $i;
                }
            }
        }

        return $collection;
    }

    /* public function getAllParents()
     {
         $sections = new Collection();

         foreach ($this->parent as $section) {
             $sections->push($section);
             $sections = $sections->merge($section->getAllParents());
         }

         return $sections;
     }*/


    public function getCreatedAtAttribute($value)
    {
        $timezone = optional(auth()->user())->timezone ?? config('app.timezone');
        return Carbon::parse($value)->timezone($timezone);
    }

    public function getUpdatedAtAttribute($value)
    {
        $timezone = optional(auth()->user())->timezone ?? config('app.timezone');
        return Carbon::parse($value)->timezone($timezone);
    }


    public function allTree(CoachProfileInfo $coachProfileInfo)
    {
        $childs = [];
        $childMembers = CoachProfileInfo::where('referral_invite_code', $coachProfileInfo->invite_code)->get()->toArray();


        while (count($childMembers) > 0) {
            $nextChilds = [];
            foreach ($childMembers as $item) {
                $childs[] = $item;

                $nextChild = CoachProfileInfo::where('referral_invite_code', $item['invite_code'])->get()->toArray();

                if (count($nextChild) > 0) {
                    $nextChilds = array_merge($nextChilds, $nextChild);
                }

            }
            $childMembers = $nextChilds;
        }


        return new Collection(array_unique(Arr::pluck($childs, 'created_user_id')));
    }
}


