<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    protected $table = 'categories';

    protected $fillable = [
        'title', 'description', 'status', 'created_user_id', 'updated_user_id'
    ];

    public function user()
    {
        return $this->belongsTo('App\User');
    }

    public function Videos()
    {
        return $this->belongsToMany(Video::class, 'video_categories');
    }
}


